/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.model.telemetry.UserLoginEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class UserLoginEventStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserLoginEventStore.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private Set<UserLoginEvent> events = ConcurrentHashMap.newKeySet();

    @EventListener
    public void add(UserLoginEvent event) {
        this.readLock.lock();
        try {
            this.events.add(event);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<UserLoginEvent> drain() {
        Set result;
        this.writeLock.lock();
        try {
            result = this.events;
            this.events = ConcurrentHashMap.newKeySet();
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    public int loginEventsCount() {
        return this.events.size();
    }
}

