/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.InstanceDataDAO;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.telemetry.ClusterUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.service.telemetry.FeatureUsageTracker;
import com.hazelcast.webmonitor.service.telemetry.InstanceDataTracker;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeDataSupplier;
import com.hazelcast.webmonitor.service.telemetry.PhoneHomeService;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStore;
import jakarta.servlet.ServletContext;
import java.time.Clock;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"hazelcast.mc.phone.home.enabled"}, matchIfMissing=true)
public class PhoneHomeConfig {
    public static final String PHONE_HOME_URL = "http://phonehome.hazelcast.com/pingMc";

    @Bean
    public PhoneHomeService phoneHomeService(PhoneHomeDataSupplier phoneHomeDataSupplier) {
        return new PhoneHomeService(PHONE_HOME_URL, phoneHomeDataSupplier);
    }

    @Bean
    public PhoneHomeDataSupplier phoneHomeDataFactory(MCConfigurationProperties mcProperties, JMXConfigurationProperties jmxProperties, ServletContext servletContext, LicenseManager licenseManager, UserLoginEventStore userLoginEventStore, AuthenticationManagerImpl authenticationManager, HomeDirectoryProvider homeDirectoryProvider, List<DataCollector> additionalCollectors) {
        return new PhoneHomeDataSupplier(jmxProperties, mcProperties, servletContext.getServerInfo(), licenseManager, userLoginEventStore, authenticationManager, homeDirectoryProvider, additionalCollectors);
    }

    @Bean
    public FeatureUsageTracker featureUsageCounterCollector() {
        return new FeatureUsageTracker();
    }

    @Bean
    public UserLoginEventStore userLoginEventStore() {
        return new UserLoginEventStore();
    }

    @Bean
    public ClusterUsageTracker clusterUsageTracker(OperationDispatcher operationDispatcher, ClusterManager clusterManager) {
        return new ClusterUsageTracker(operationDispatcher, clusterManager);
    }

    @Bean
    public InstanceDataTracker instanceDataTracker(InstanceDataDAO dao) {
        return new InstanceDataTracker(dao, Clock.systemDefaultZone());
    }
}

