/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.MetricsAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcessorCountThresholdAnalyzer
extends MetricsAnalyzer {
    ProcessorCountThresholdAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    List<Problem> identifyProblems(String cluster, Stream<Map.Entry<MemberIdentifier, List<MetricDataPoint>>> metricsMap) {
        return metricsMap.map(entry -> {
            List metricDataPoints = (List)entry.getValue();
            long processorCount = ((MetricDataPoint)metricDataPoints.get(metricDataPoints.size() - 1)).getValue();
            return Map.entry((MemberIdentifier)entry.getKey(), processorCount);
        }).filter(entry -> (Long)entry.getValue() < 8L).map(entry -> new MemberProblem(String.format("Member is running with %s processors", entry.getValue()), String.format("Minimum recommended number of processors for a member is %s for better performance", 8L), Problem.ProblemType.WARNING, (MemberIdentifier)entry.getKey())).collect(Collectors.toList());
    }

    public boolean isProcessorCountBelowThreshold(MemberIdentifier memberIdentifier) {
        return this.analyze(new SourceDataFilter(memberIdentifier.getClusterName()), IgnoreList.emptyIgnoreList()).getProblems().stream().anyMatch(problem -> ((MemberProblem)problem).getMember().equals((Object)memberIdentifier));
    }

    String getMetricName() {
        return Metric.RUNTIME_AVAILABLE_PROCESSORS.getName();
    }

    String getCheckId() {
        return AnalyzerCheckId.PROCESSOR_COUNT_THRESHOLD_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if members are running with sufficient number of processors";
    }
}

