/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.List;
import java.util.stream.Collectors;

class NearCacheEvictionConfigAnalyzer
extends SemanticConfigAnalyzer {
    NearCacheEvictionConfigAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    String getCheckId() {
        return AnalyzerCheckId.NEAR_CACHE_EVICTION_CONFIG_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if eviction policy and size is configured properly for near cache";
    }

    List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).filter(NearCacheEvictionConfigAnalyzer::hasNoEvictionPolicyButHasSize).map(NearCacheEvictionConfigAnalyzer::toProblem).collect(Collectors.toUnmodifiableList());
    }

    private static boolean hasNoEvictionPolicyButHasSize(MapConfig mapConfig) {
        NearCacheConfig nearCacheConfig = mapConfig.getNearCacheConfig();
        if (nearCacheConfig != null) {
            EvictionConfig evictionConfig = mapConfig.getNearCacheConfig().getEvictionConfig();
            return evictionConfig.getEvictionPolicy() == EvictionPolicy.NONE && evictionConfig.getSize() > 0;
        }
        return false;
    }

    private static ClusterWideProblem toProblem(MapConfig mapConfig) {
        String mapName = mapConfig.getName();
        return new ClusterWideProblem(String.format("Near cache eviction size is set as %d for map config %s but eviction policy is NONE.", mapConfig.getNearCacheConfig().getEvictionConfig().getSize(), mapName), String.format("Set an eviction policy other than NONE or set size to zero in near cache configuration for map config %s.", mapName), Problem.ProblemType.WARNING, mapName);
    }
}

