/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
class MapCustomAttributeAnalyzer
extends SemanticConfigAnalyzer {
    MapCustomAttributeAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    protected List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        ArrayList<Problem> rval = new ArrayList<Problem>();
        config.toEffectiveConfig().getMapConfigs().forEach((mapName, mapCfg) -> {
            if (disabledDataStructures.contains(mapName)) {
                return;
            }
            List attributeConfigs = mapCfg.getAttributeConfigs();
            if (attributeConfigs != null && !attributeConfigs.isEmpty()) {
                HashMap extractorsByAttribute = new HashMap(attributeConfigs.size());
                HashMap attributesByExtractor = new HashMap(attributeConfigs.size());
                attributeConfigs.forEach(attrCfg -> {
                    extractorsByAttribute.computeIfAbsent(attrCfg.getName(), attrName -> new HashSet(1)).add(attrCfg.getExtractorClassName());
                    attributesByExtractor.computeIfAbsent(attrCfg.getExtractorClassName(), name -> new HashSet(1)).add(attrCfg.getName());
                });
                extractorsByAttribute.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> rval.add((Problem)new ClusterWideProblem(String.format("Custom attribute %s of map config %s contains more than one extractors: %s", entry.getKey(), mapName, MapCustomAttributeAnalyzer.joinSorted((Collection)((Collection)entry.getValue()))), String.format("Configure %s with exactly one extractor class", entry.getKey()), Problem.ProblemType.FAIL, mapName)));
                attributesByExtractor.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> rval.add((Problem)new ClusterWideProblem(String.format("Attribute extractor %s is configured in map config %s to extract multiple attributes: %s", entry.getKey(), mapName, MapCustomAttributeAnalyzer.joinSorted((Collection)((Collection)entry.getValue()))), String.format("Configure %s to extract only one attribute", entry.getKey()), Problem.ProblemType.FAIL, mapName)));
            }
        });
        return rval;
    }

    private static String joinSorted(Collection<String> elems) {
        ArrayList<String> copy = new ArrayList<String>(elems);
        copy.sort(String::compareTo);
        return String.join((CharSequence)", ", copy);
    }

    public String describeSelf() {
        return "Checking if custom attributes are unique per extractor";
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_CUSTOM_ATTRIBUTE_ANALYZER.getCheckId();
    }
}

