/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

abstract class EqualityAnalyzer
extends SourceDataPoolAwareAnalyzer {
    protected final MemberConfigSupplier memberConfigs;

    EqualityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
        this.memberConfigs = this.pool.subscribeToConfig();
    }

    @Nonnull
    public final AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        ArrayList problems = new ArrayList();
        filter.filter((MemberConfigMap)this.memberConfigs.get()).groupByCluster().forEach((clusterName, memberConfigs) -> {
            Map<MemberIdentifier, Config> effectiveConfigs = memberConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MemberConfig)entry.getValue()).toEffectiveConfig()));
            effectiveConfigs.forEach((member, config) -> config.getMapConfigs().forEach((name, mapCfg) -> {
                if (mapCfg.getNearCacheConfig() != null && mapCfg.getNearCacheConfig().getName() == null) {
                    mapCfg.getNearCacheConfig().setName("");
                }
            }));
            problems.addAll(this.identifyProblems(effectiveConfigs));
        });
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    protected <Attr> Map<MemberIdentifier, Attr> extractConfigAttribute(Map<MemberIdentifier, Config> effectiveConfigs, Function<Config, Attr> attributeExtractor) {
        HashMap groupsByValues = new HashMap();
        effectiveConfigs.forEach((member, config) -> groupsByValues.put(member, attributeExtractor.apply((Config)config)));
        return groupsByValues;
    }

    protected abstract List<Problem> identifyProblems(Map<MemberIdentifier, Config> var1);
}

