/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithConnectionInfoDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientCountAnalyzer
extends Analyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCountAnalyzer.class);
    public static final String CLIENT_COUNT_ANALYZER_DESCRIPTION = "Checking if the number of clients per member is exceeded";
    public static final String CLIENT_COUNT_ANALYZER_ADVICE = "See Hazelcast Support for further details at https://support.hazelcast.com/s/article/Hazelcast-Support-Policy";
    public static final int MAXIMUM_SINGLE_MEMBER_CLIENTS_PER_MEMBER = 1000;
    public static final int MAXIMUM_MULTI_OR_ALL_MEMBER_CLIENTS_PER_MEMBER = 100;
    private final StateManager stateManager;

    @Nonnull
    AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        AllState latestState = this.stateManager.getLatestState(filter.getCluster());
        if (latestState == null) {
            return AnalysisOutcome.noProblem((String)this.getCheckId(), (String)this.describeSelf());
        }
        int memberCount = latestState.getMembers().size();
        ArrayList problems = new ArrayList();
        latestState.getClientsPerUuid().values().stream().map(client -> ClientWithConnectionInfoDTO.inferRoutingMode((ClientEndPointDTO)client, (Set)latestState.getMembersPerClientUuid(client.getUuid()))).collect(Collectors.groupingBy(arg_0 -> RoutingMode.SINGLE_MEMBER.equals(arg_0), Collectors.counting())).forEach((isSingleMember, count) -> this.getClusterProblem(count.longValue(), memberCount, isSingleMember.booleanValue()).ifPresent(problems::add));
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    private Optional<Problem> getClusterProblem(long clientsCount, int membersCount, boolean isSingleMemberClient) {
        long maxClientsPerMember;
        long l = maxClientsPerMember = isSingleMemberClient ? 1000L : 100L;
        if (clientsCount > (long)membersCount * maxClientsPerMember) {
            String description = String.format("%,d clients with %s routing mode connected to cluster with %d members which exceeds Hazelcast Best Practices", clientsCount, isSingleMemberClient ? "single member" : "multi member or all members", membersCount);
            log.debug(description);
            return Optional.of(new ClusterWideProblem(description, CLIENT_COUNT_ANALYZER_ADVICE, Problem.ProblemType.WARNING));
        }
        return Optional.empty();
    }

    public String describeSelf() {
        return CLIENT_COUNT_ANALYZER_DESCRIPTION;
    }

    String getCheckId() {
        return AnalyzerCheckId.CLIENT_COUNT_ANALYZER.getCheckId();
    }

    @ConstructorProperties(value={"stateManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientCountAnalyzer(StateManager stateManager) {
        this.stateManager = stateManager;
    }
}

