/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.cp.CPMapConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.CPMapAttributeEquality;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import java.util.Map;
import java.util.Set;

class CPMapListEquivalence
extends ListEquivalence<Config, CPMapConfig, String> {
    CPMapListEquivalence(Map<MemberIdentifier, Config> memberConfigs) {
        super(memberConfigs, true);
    }

    AttributeEquivalence<CPMapConfig> createElementAttributeEquivalence(String elemId, Map<CPMapConfig, Set<MemberIdentifier>> groupsByValues) {
        return new CPMapAttributeEquality(groupsByValues, elemId);
    }

    MemberComparisonProblem createProblemForMissingElement(String elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.builder().description(String.format("CPMap %s is not configured on all members", elemId)).advice(String.format("Configure CPMap %s on all members", elemId)).type(Problem.ProblemType.FAIL).addOutlierGroup(OutlierGroup.of((String)(elemId + " is configured"), membersContainingTheElem)).addOutlierGroup(OutlierGroup.of((String)(elemId + " is missing"), membersMissingTheElem)).build();
    }

    CPMapConfig createDefaultElemForIdentifier(Config config, String cpMapName) {
        return new CPMapConfig(cpMapName);
    }

    Config extractOwner(Config config) {
        return config;
    }

    Map<String, CPMapConfig> extractElements(Config owner) {
        return owner.getCPSubsystemConfig().getCpMapConfigs();
    }
}

