/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigMap;
import com.hazelcast.webmonitor.service.healthcheck.MemberConfigSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDeviceAnalyzer
extends SourceDataPoolAwareAnalyzer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDeviceAnalyzer.class);
    private final MemberConfigSupplier memberConfigs;
    private final MemberMetricsSupplier memberMetrics;

    AbstractDeviceAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
        this.memberConfigs = this.pool.subscribeToConfig();
        this.memberMetrics = this.pool.subscribeToMetric(this.getMetricName());
    }

    abstract String getMetricName();

    @Nonnull
    public AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        ArrayList problems = new ArrayList();
        filter.filter((Map)this.memberMetrics.get()).forEach((memberIdentifier, metricDataPointList) -> {
            if (metricDataPointList != null) {
                Optional.ofNullable((MemberConfig)((MemberConfigMap)this.memberConfigs.get()).get(memberIdentifier)).map(MemberConfig::toEffectiveConfig).map(Config::getDeviceConfigs).ifPresent(deviceConfigMap -> deviceConfigMap.forEach((deviceName, deviceConfig) -> metricDataPointList.forEach(metricDataPoint -> Optional.ofNullable((String)metricDataPoint.getTags().get("name")).filter(deviceName::equals).flatMap(tag -> this.getMemberProblem(memberIdentifier, deviceName, deviceConfig, metricDataPoint)).ifPresent(problems::add))));
            }
        });
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    protected abstract Optional<MemberProblem> getMemberProblem(MemberIdentifier var1, String var2, DeviceConfig var3, MetricDataPoint var4);

    static String getDeviceBaseDirOrNull(DeviceConfig deviceConfig) {
        LocalDeviceConfig localDeviceConfig;
        File baseDir;
        String baseDirPath = null;
        if (deviceConfig instanceof LocalDeviceConfig && (baseDir = (localDeviceConfig = (LocalDeviceConfig)deviceConfig).getBaseDir()) != null) {
            baseDirPath = baseDir.getAbsolutePath();
        }
        return baseDirPath;
    }
}

