/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.diagnosticsconfig;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.internal.diagnostics.DiagnosticsConfig;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.DiagnosticsConfigResponseDTO;
import com.hazelcast.webmonitor.controller.dto.diagnosticconfig.UpdateDiagnosticsConfigRequestDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.events.DiagnosticsConfigUpdatedEventStore;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.DiagnosticsConfigUpdatedEvent;
import com.hazelcast.webmonitor.service.ClusterRemovedEvent;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.diagnosticsconfig.GetDiagnosticsConfigPlatformResponse;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class DiagnosticsConfigManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsConfigManager.class);
    private static final int DIAGNOSTIC_CONFIG_CACHE_MAX_SIZE = 1000;
    private static final int RETRY_DELAY_FETCHING_DIAGNOSTICS_CONFIG_SECONDS = 5;
    private final OperationDispatcher dispatcher;
    private final DiagnosticsConfigUpdatedEventStore eventStore;
    private final Cache<String, DiagnosticsConfigResponseDTO> diagnosticConfigCache = Caffeine.newBuilder().maximumSize(1000L).build();
    private final ConcurrentMap<String, Future<?>> retryTasks = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler;

    @Autowired
    DiagnosticsConfigManager(OperationDispatcher dispatcher, DiagnosticsConfigUpdatedEventStore eventStore) {
        this(dispatcher, eventStore, Executors.newSingleThreadScheduledExecutor());
    }

    @PreDestroy
    public void shutdown() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.scheduler);
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        this.invalidateCache(event.getCluster());
    }

    @EventListener
    public void onMemberRemoved(MemberRemovedEvent event) {
        this.invalidateCache(event.getCluster());
    }

    @EventListener
    public void onClusterDisconnected(DisconnectedFromClusterEvent event) {
        this.invalidateCache(event.getCluster());
    }

    @EventListener
    public void onClusterRemoved(ClusterRemovedEvent event) {
        this.invalidateCache(event.getCluster());
    }

    @EventListener
    public void onDiagnosticsConfigUpdated(DiagnosticsConfigUpdatedEvent event) {
        String clusterName = event.getClusterName();
        this.cancelPendingRetries(clusterName);
        this.tryProcessConfigUpdate(event);
    }

    public DiagnosticsConfigResponseDTO getDiagnosticsConfigurationWithDetails(String clusterName) {
        DiagnosticsConfigResponseDTO cachedConfig = (DiagnosticsConfigResponseDTO)this.diagnosticConfigCache.getIfPresent((Object)clusterName);
        if (cachedConfig != null) {
            if (cachedConfig.isEnabledAtUnknownTime()) {
                DiagnosticsConfigResponseDTO enrichedConfig = this.enrichedWithLastEnabledAt(clusterName, cachedConfig);
                this.diagnosticConfigCache.put((Object)clusterName, (Object)enrichedConfig);
                return enrichedConfig;
            }
            return cachedConfig;
        }
        return (DiagnosticsConfigResponseDTO)this.diagnosticConfigCache.get((Object)clusterName, it -> {
            GetDiagnosticsConfigPlatformResponse diagnosticsConfig = this.fetchDiagnosticsConfigFromCluster(clusterName);
            if (null == diagnosticsConfig) {
                return null;
            }
            DiagnosticsConfigResponseDTO responseDto = DiagnosticsConfigResponseDTO.fromConfig((GetDiagnosticsConfigPlatformResponse)diagnosticsConfig);
            if (diagnosticsConfig.isEnabledDynamically()) {
                return this.enrichedWithLastEnabledAt(clusterName, responseDto);
            }
            return responseDto;
        });
    }

    public void changeDiagnosticsConfigurationState(String clusterName, UpdateDiagnosticsConfigRequestDTO updateRequest) {
        GetDiagnosticsConfigPlatformResponse currentDiagnosticsConfig = this.fetchDiagnosticsConfigFromCluster(clusterName);
        if (null == currentDiagnosticsConfig) {
            throw new OperationFailedApiException("Can't update the diagnostic configuration. The diagnostics configuration for cluster %s is not available".formatted(clusterName));
        }
        if (!currentDiagnosticsConfig.canBeConfiguredDynamically()) {
            throw new OperationFailedApiException("The diagnostics configuration for %s cannot be updated dynamically.".formatted(clusterName));
        }
        boolean shouldBeEnabled = updateRequest.isEnabled();
        if (currentDiagnosticsConfig.isEnabled() == shouldBeEnabled) {
            throw new OperationFailedApiException("The diagnostics configuration for %s is already in the enabled=%b state.".formatted(clusterName, shouldBeEnabled));
        }
        DiagnosticsConfig newDiagnosticsConfig = updateRequest.toNewDiagnosticsConfig(currentDiagnosticsConfig.getDiagnosticsConfig());
        this.dispatcher.executeOnCluster(clusterName, mcClient -> mcClient.updateDiagnosticsConfig(newDiagnosticsConfig), err -> "One or more members failed to start diagnostics logging on cluster %s. Check cluster logs for more details.".formatted(clusterName));
    }

    private void cancelPendingRetries(String clusterName) {
        Future pendingTask = (Future)this.retryTasks.remove(clusterName);
        if (pendingTask != null) {
            pendingTask.cancel(false);
            log.info("Cancelled pending diagnostics config update retry for cluster {} due to new event.", (Object)clusterName);
        }
    }

    private void tryProcessConfigUpdate(DiagnosticsConfigUpdatedEvent event) {
        String clusterName = event.getClusterName();
        GetDiagnosticsConfigPlatformResponse currentMemberConfig = this.fetchDiagnosticsConfigFromCluster(clusterName);
        if (currentMemberConfig == null) {
            log.warn("Could not fetch diagnostics config for cluster {}. Will retry in 5 seconds.", (Object)clusterName);
            this.retryTasks.computeIfAbsent(clusterName, k -> this.scheduler.schedule(() -> {
                this.retryTasks.remove(k);
                this.tryProcessConfigUpdate(event);
            }, 5L, TimeUnit.SECONDS));
            return;
        }
        DiagnosticsConfigResponseDTO newConfigDto = this.buildDtoWithUpdatedEventTimestamps(event, currentMemberConfig);
        this.diagnosticConfigCache.put((Object)clusterName, (Object)newConfigDto);
        log.info("Updated diagnostics config cache for cluster {}.", (Object)clusterName);
    }

    private DiagnosticsConfigResponseDTO buildDtoWithUpdatedEventTimestamps(DiagnosticsConfigUpdatedEvent event, GetDiagnosticsConfigPlatformResponse currentMemberConfig) {
        String clusterName = event.getClusterName();
        DiagnosticsConfigResponseDTO previousConfig = (DiagnosticsConfigResponseDTO)this.diagnosticConfigCache.getIfPresent((Object)clusterName);
        DiagnosticsConfigResponseDTO newConfig = DiagnosticsConfigResponseDTO.fromConfig((GetDiagnosticsConfigPlatformResponse)currentMemberConfig);
        if (null == previousConfig) {
            log.info("Diagnostics config for cluster {} was not found in cache", (Object)clusterName);
            return newConfig;
        }
        if (previousConfig.isEnabled() && !newConfig.isEnabled() && !event.isEnabled().booleanValue()) {
            log.info("Diagnostics config for cluster {} has changed to disabled", (Object)clusterName);
            return newConfig.withLastDisabledAt(Long.valueOf(event.getTimestamp())).withLastEnabledAt(null);
        }
        if (previousConfig.isEnabled() && null == previousConfig.getDiagnosticsConfigMetadata().getLastEnabledAt() && event.isEnabled().booleanValue()) {
            log.info("Diagnostics config for cluster {} remains enabled", (Object)clusterName);
            return this.enrichedWithLastEnabledAt(clusterName, newConfig);
        }
        if (!previousConfig.isEnabled() && newConfig.isEnabled() && event.isEnabled().booleanValue()) {
            log.info("Diagnostics config for cluster {} has changed to enabled", (Object)clusterName);
            return newConfig.withLastEnabledAt(Long.valueOf(event.getTimestamp())).withLastDisabledAt(null);
        }
        log.info("Diagnostics config for cluster {} was updated", (Object)clusterName);
        return newConfig.withLastEnabledAt(previousConfig.getDiagnosticsConfigMetadata().getLastEnabledAt()).withLastDisabledAt(previousConfig.getDiagnosticsConfigMetadata().getLastDisabledAt());
    }

    private DiagnosticsConfigResponseDTO enrichedWithLastEnabledAt(String clusterName, DiagnosticsConfigResponseDTO responseDto) {
        return this.eventStore.findLastEventByState(clusterName, true).map(AbstractEvent::getTimestamp).map(arg_0 -> ((DiagnosticsConfigResponseDTO)responseDto).withLastEnabledAt(arg_0)).orElse(responseDto);
    }

    @VisibleForTesting
    GetDiagnosticsConfigPlatformResponse fetchDiagnosticsConfigFromCluster(String clusterName) {
        GetDiagnosticsConfigPlatformResponse config;
        try {
            config = (GetDiagnosticsConfigPlatformResponse)this.dispatcher.executeOnCluster(clusterName, MCClient::getDiagnosticsConfig, e -> "Failed to get diagnostic config for cluster = %s".formatted(clusterName));
        }
        catch (Exception e2) {
            log.warn("Couldn't load diagnostic config for cluster %s".formatted(clusterName), (Throwable)e2);
            return null;
        }
        log.info("Diagnostics config was loaded for cluster {}", (Object)clusterName);
        return config;
    }

    private void invalidateCache(String clusterName) {
        this.cancelPendingRetries(clusterName);
        this.diagnosticConfigCache.invalidate((Object)clusterName);
    }

    @ConstructorProperties(value={"dispatcher", "eventStore", "scheduler"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagnosticsConfigManager(OperationDispatcher dispatcher, DiagnosticsConfigUpdatedEventStore eventStore, ScheduledExecutorService scheduler) {
        this.dispatcher = dispatcher;
        this.eventStore = eventStore;
        this.scheduler = scheduler;
    }
}

