/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListPreviewDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientFilteringListWithEntriesDTO;
import com.hazelcast.webmonitor.controller.dto.client.MemberClientFilteringListConfigDTO;
import com.hazelcast.webmonitor.controller.dto.clustered.ClientFilteringTestDeployDTO;
import com.hazelcast.webmonitor.controller.exception.FailureApiException;
import com.hazelcast.webmonitor.controller.exception.InvalidOperationApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringConfigModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListEntryModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListStatus;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListType;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringListWithEntries;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringMode;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringStatus;
import com.hazelcast.webmonitor.model.sql.client.DeployedClientFilteringConfig;
import com.hazelcast.webmonitor.repositories.sql.ClientFilteringDAO;
import com.hazelcast.webmonitor.service.ClusterClientFilteringDTO;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.EnterpriseServiceProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringSharedSource;
import com.hazelcast.webmonitor.service.client_filtering.ClientFilteringUtil;
import com.hazelcast.webmonitor.service.client_filtering.ClusterLockManager;
import com.hazelcast.webmonitor.service.client_filtering.LoggingReadWriteLock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.springframework.stereotype.Service;

@Service
public class ClientFilteringService {
    private static final Feature FEATURE = Feature.CLIENT_FILTERING;
    private static final MemberClientFilteringListConfigDTO DEFAULT_STATE = new MemberClientFilteringListConfigDTO("00000000-0000-0000-0000-000000000000", ClientFilteringMode.DISABLED, Collections.emptyList());
    private final Jdbi jdbi;
    private final ClientFilteringDAO dao;
    private final LicenseManager licenseManager;
    private final ClientFilteringSharedSource clientFilteringSharedSource;
    private final ClusterLockManager clusterLockManager;
    private final ClusterManager clusterManager;
    private final EnterpriseServiceProvider enterpriseServiceProvider;
    private final MCConfigurationProperties mcProperties;

    public ClientFilteringConfigModel getClientFilteringConfig(String cluster) {
        return (ClientFilteringConfigModel)this.dao.findClientFilteringConfig(cluster).orElseThrow(() -> new NoClusterApiException(cluster));
    }

    public MemberClientFilteringListConfigDTO getDeployedForMembers(String cluster) {
        return (MemberClientFilteringListConfigDTO)this.findDeployedForMembers(cluster).orElseThrow(() -> new NoClusterApiException(cluster));
    }

    Optional<MemberClientFilteringListConfigDTO> findDeployedForMembers(String cluster) {
        if (!this.hasLicensedFeature()) {
            return Optional.of(DEFAULT_STATE);
        }
        return this.dao.findDeployedWithEntries(cluster).map(MemberClientFilteringListConfigDTO::fromModel);
    }

    public ClusterClientFilteringDTO getFullClientFilteringConfigForCluster(String cluster) {
        Optional deployed = this.dao.findDeployedWithEntries(cluster);
        if (deployed.isPresent()) {
            DeployedClientFilteringConfig deployedClientFiltering = (DeployedClientFilteringConfig)deployed.get();
            List<ClientFilteringListWithEntriesDTO> allWithEntries = this.dao.findAllWithEntries(cluster).stream().map(ClientFilteringListWithEntriesDTO::fromModel).toList();
            return ClusterClientFilteringDTO.builder().status(deployedClientFiltering.getStatus()).type(deployedClientFiltering.getType()).etag(deployedClientFiltering.getEtag()).allClientFilteringLists(allWithEntries).build();
        }
        throw new NoClusterApiException(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String cluster, ClientFilteringStatus status, ClientFilteringListType type, String deployedETag) {
        EnumSet clientFilteringModes = this.mcProperties.getClientFilteringModes();
        LoggingReadWriteLock lockForCluster = this.clusterLockManager.getLockForCluster(cluster);
        if (!lockForCluster.acquireWriteLock()) {
            throw new FailureApiException("Can't acquire lock for cluster " + cluster);
        }
        try {
            if (!clientFilteringModes.contains(type) && status != ClientFilteringStatus.DISABLED) {
                throw new FailureApiException("Filter type is not allowed. The following values are valid: %s".formatted(clientFilteringModes));
            }
            this.jdbi.useTransaction(handle -> {
                ClientFilteringConfigModel savedConfig = (ClientFilteringConfigModel)this.dao.findConfigByCluster(cluster).orElseThrow(() -> new NoClusterApiException(cluster));
                savedConfig.setStatus(status);
                savedConfig.setType(type);
                savedConfig.setEtag(deployedETag);
                this.dao.updateConfigTx(handle, savedConfig);
            });
            if (this.clusterManager.isClusterConnected(cluster)) {
                this.clientFilteringSharedSource.put(cluster, this.getFullClientFilteringConfigForCluster(cluster));
            }
        }
        finally {
            lockForCluster.releaseWriteLock();
        }
    }

    public void deploy(String cluster, ClientFilteringStatus status, ClientFilteringListType type) {
        this.deploy(cluster, status, type, UuidUtil.newUnsecureUuidString());
    }

    public List<ClientFilteringListEntryModel> getActiveEntries(String cluster, ClientFilteringListType type, @Nullable Long excludedListId) {
        return this.dao.findAllFilteredWithEntries(cluster, ClientFilteringListStatus.ACTIVE, type).stream().map(ClientFilteringListWithEntries::getEntries).flatMap(Collection::stream).filter(clientFilteringListEntryModel -> !clientFilteringListEntryModel.getListId().equals(excludedListId)).toList();
    }

    public List<ClientFilteringListWithEntries> getAll(String cluster) {
        return this.dao.findAllWithEntries(cluster);
    }

    public ClientFilteringListWithEntries get(Long listId) {
        return (ClientFilteringListWithEntries)this.dao.findWithEntries(listId).orElseThrow(() -> new NoResourceApiException(listId));
    }

    public ClientFilteringListWithEntries create(String cluster, ClientFilteringListWithEntries newListModel) {
        return this.create(cluster, newListModel, true);
    }

    public ClientFilteringListWithEntries create(String cluster, ClientFilteringListWithEntries newListModel, boolean deploy) {
        Long newListId = (Long)this.jdbi.inTransaction(handle -> {
            newListModel.setCluster(cluster);
            Long listId = this.dao.insertTx(handle, (ClientFilteringListModel)newListModel);
            if (newListModel.getEntries() != null) {
                for (ClientFilteringListEntryModel entryModel : newListModel.getEntries()) {
                    entryModel.setListId(listId);
                    this.dao.insertEntryTx(handle, entryModel);
                }
            }
            return listId;
        });
        if (deploy) {
            this.redeployChanges(cluster);
        }
        return this.get(newListId);
    }

    public void update(String cluster, ClientFilteringListWithEntries listModel) {
        ClientFilteringListModel found = (ClientFilteringListModel)this.dao.findById(listModel.getId()).orElseThrow(() -> new NoResourceApiException(listModel.getId()));
        if (!cluster.equals(found.getCluster())) {
            throw new InvalidOperationApiException("Cluster and list mismatch.");
        }
        this.jdbi.inTransaction(handle -> {
            listModel.setCluster(cluster);
            this.dao.updateTx(handle, (ClientFilteringListModel)listModel);
            Long listId = listModel.getId();
            this.dao.deleteAllEntriesTx(handle, listId);
            if (listModel.getEntries() != null) {
                for (ClientFilteringListEntryModel entryModel : listModel.getEntries()) {
                    entryModel.setListId(listId);
                    this.dao.insertEntryTx(handle, entryModel);
                }
            }
            return null;
        });
        this.redeployChanges(cluster);
    }

    public void delete(String cluster, Long listId) {
        ClientFilteringListModel found = (ClientFilteringListModel)this.dao.findById(listId).orElseThrow(() -> new NoResourceApiException(listId));
        if (!cluster.equals(found.getCluster())) {
            throw new InvalidOperationApiException("Cluster and list mismatch.");
        }
        this.jdbi.inTransaction(handle -> {
            this.dao.deleteAllEntriesTx(handle, listId);
            this.dao.deleteTx(handle, listId);
            return null;
        });
        this.redeployChanges(cluster);
    }

    public void deleteAll(String cluster) {
        this.deleteAll(cluster, true);
    }

    public void deleteAll(String cluster, boolean deploy) {
        List allWithEntries = this.dao.findAllWithEntries(cluster);
        this.jdbi.inTransaction(handle -> {
            allWithEntries.forEach(entry -> {
                Long listId = entry.getId();
                this.dao.deleteAllEntriesTx(handle, listId);
                this.dao.deleteTx(handle, listId);
            });
            return null;
        });
        if (deploy) {
            this.redeployChanges(cluster);
        }
    }

    public boolean hasLicensedFeature() {
        try {
            this.licenseManager.checkLicensePerFeature(Feature.CLIENT_FILTERING);
            return true;
        }
        catch (InvalidLicenseException e) {
            return false;
        }
    }

    private void redeployChanges(String cluster) {
        this.dao.findConfigByCluster(cluster).ifPresent(config -> this.deploy(cluster, config.getStatus(), config.getType()));
    }

    public ClientFilteringTestDeployDTO testDeploy(String cluster, ClientFilteringListType type) {
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        Collection clients = latestState.getClientsPerUuid().values();
        List entries = this.getActiveEntries(cluster, type, null);
        return ClientFilteringUtil.testDeploy((ClientFilteringListType)type, (List)entries, clients);
    }

    public ClientFilteringTestDeployDTO preview(String cluster, ClientFilteringListPreviewDTO input) {
        ClientFilteringListType clusterConfigType = this.getClientFilteringConfig(cluster).getType();
        List entries = this.getEffectiveEntries(cluster, input, clusterConfigType);
        AllState latestState = this.enterpriseServiceProvider.getLatestState(cluster, FEATURE);
        Collection clients = latestState.getClientsPerUuid().values();
        return ClientFilteringUtil.testDeploy((ClientFilteringListType)clusterConfigType, (List)entries, clients);
    }

    @VisibleForTesting
    List<ClientFilteringListEntryModel> getEffectiveEntries(String cluster, ClientFilteringListPreviewDTO input, ClientFilteringListType clusterConfigType) {
        List savedEntries = this.getActiveEntries(cluster, clusterConfigType, input.getId());
        if (input.getStatus() == ClientFilteringListStatus.INACTIVE || clusterConfigType != input.getType()) {
            return savedEntries;
        }
        List<ClientFilteringListEntryModel> entries = Optional.ofNullable(input.getEntries()).orElse(Collections.emptyList()).stream().map(entryDTO -> {
            ClientFilteringListEntryModel model = entryDTO.toModel();
            model.setListId(input.getId());
            return model;
        }).collect(Collectors.toList());
        entries.addAll(savedEntries);
        return entries;
    }

    @ConstructorProperties(value={"jdbi", "dao", "licenseManager", "clientFilteringSharedSource", "clusterLockManager", "clusterManager", "enterpriseServiceProvider", "mcProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientFilteringService(Jdbi jdbi, ClientFilteringDAO dao, LicenseManager licenseManager, ClientFilteringSharedSource clientFilteringSharedSource, ClusterLockManager clusterLockManager, ClusterManager clusterManager, EnterpriseServiceProvider enterpriseServiceProvider, MCConfigurationProperties mcProperties) {
        this.jdbi = jdbi;
        this.dao = dao;
        this.licenseManager = licenseManager;
        this.clientFilteringSharedSource = clientFilteringSharedSource;
        this.clusterLockManager = clusterLockManager;
        this.clusterManager = clusterManager;
        this.enterpriseServiceProvider = enterpriseServiceProvider;
        this.mcProperties = mcProperties;
    }
}

