/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MemberStateReceivedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.NodeLimitStatus;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.TimedMemberStateConsumer;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import com.hazelcast.webmonitor.utils.MemberUtil;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class TimedMemberStateConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimedMemberStateConsumer.class);
    private static final Logger STATE_PROCESSING_ERROR_LOGGER = RateLimitedLog.withRateLimit((Logger)log).maxRate(1).every(Duration.of(1L, ChronoUnit.MINUTES)).build();
    final TMSJsonReader tmsJsonReader = new TMSJsonReader();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("TimedMemberStateConsumer-%d").build());
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final StateManager stateManager;
    private final LicenseManager licenseManager;
    private final NodeLimitStatus nodeLimitStatus;
    private final MCClientManager mcClientManager;
    private final ClusterManager clusterManager;
    private final Notifier notifier;
    private final MetricsConfigurationProperties properties;
    private final ApplicationEventPublisher eventPublisher;

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        for (Member member : event.getJoinedMembers()) {
            this.scheduleReadState(this.nextChainId(member), client, member, Duration.ZERO);
        }
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        Member member = event.getRemovedMember();
        int nextId = this.nextChainId(member);
        log.debug("Cleaning chain {} for member {}", (Object)nextId, (Object)member);
        this.chainIdRegistry.cleanUp((Object)member, nextId);
    }

    @EventListener
    public void onClusterDisconnected(DisconnectedFromClusterEvent event) {
        for (Member member : event.getRemovedMembers()) {
            int nextId = this.nextChainId(member);
            log.debug("Cleaning chain {} for member {}", (Object)nextId, (Object)member);
            this.chainIdRegistry.cleanUp((Object)member, nextId);
        }
    }

    private void readState(int chainId, MCClient client, Member member) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        String cluster = client.getClusterName();
        log.debug("Requesting state from {} of cluster {} using client {} in chain {}.", new Object[]{member, cluster, client.getClientId(), chainId});
        client.getTimedMemberState(member).whenCompleteAsync((optionalJson, t) -> {
            if (t == null) {
                this.scheduleReadState(chainId, client, member, this.properties.getStateRescheduleDelay());
                this.processState(MemberUtil.getMemberAddress((Member)member), optionalJson, cluster);
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                log.debug("Exception when requesting state from {} of cluster {}.", new Object[]{member, cluster, error});
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleReadState(chainId, client, member, this.properties.getStateRescheduleOnErrorDelay());
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                if (this.clusterManager.isClusterConnected(cluster)) {
                    log.error("Error reading state for {} from cluster {} using client {} in chain {}. Stopped state collection for this member.", new Object[]{member, cluster, client.getClientId(), chainId, t});
                }
            }
        }, (Executor)this.executorService);
    }

    AllState processState(String memberAddress, @Nullable String json, String cluster) {
        TimedMemberState memberState = this.deserializeJson(json, cluster, memberAddress);
        if (memberState == null) {
            return null;
        }
        MemberIdentifier memberIdent = MemberIdentifier.of((String)cluster, (String)memberAddress);
        this.eventPublisher.publishEvent((ApplicationEvent)new MemberStateReceivedEvent(memberIdent, memberState));
        return this.addMemberState(memberState, cluster);
    }

    private TimedMemberState deserializeJson(@Nullable String json, String cluster, String memberAddress) {
        if (json == null) {
            log.warn("No state found on member {} from cluster {}.", (Object)memberAddress, (Object)cluster);
            return null;
        }
        try {
            return this.tmsJsonReader.read(json);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to parse statistics received from member %s of cluster %s: %s.", memberAddress, cluster, e.getMessage());
            log.warn(errorMessage, (Throwable)e);
            this.notifier.signal(Note.Matter.RECEIVED_MALFORMED_METRICS.on(cluster, errorMessage + " Check the logs for details."));
            return null;
        }
    }

    synchronized AllState addMemberState(TimedMemberState timedMemberState, String cluster) {
        List errors;
        if (this.licenseManager.isAboveMemberLimit(cluster, timedMemberState.getMembers().size())) {
            this.nodeLimitStatus.exceedsNodeLimit(cluster);
            timedMemberState.setMemberState(timedMemberState.getMemberState().toNodeLimitExceededView());
        } else {
            this.nodeLimitStatus.underNodeLimit(cluster);
        }
        long now = System.currentTimeMillis();
        AllState allState = this.stateManager.getLatestStateIfSameInterval(cluster, now);
        if (allState == null) {
            allState = new AllState();
            long time = StateManager.floorTimeToInterval((long)now);
            allState.setTime(time);
        }
        this.updateAllStateFromLatestState(cluster, allState);
        if (timedMemberState.isMaster()) {
            SortedSet liveMemberList = timedMemberState.getMembers();
            for (MemberState state : allState.getMemberStates()) {
                String address = state.getAddress();
                if (liveMemberList.contains(address)) continue;
                allState.removeMemberState(address);
            }
        }
        if (!(errors = allState.addState(timedMemberState)).isEmpty()) {
            String memberAddress = timedMemberState.getMemberState().getAddress();
            String msg = errors.stream().collect(Collectors.joining(" ", "Unable to process member state received from [" + memberAddress + "]. ", " Please check logs for the details."));
            STATE_PROCESSING_ERROR_LOGGER.warn(msg);
            this.notifier.signal(Note.Matter.RECEIVED_MALFORMED_METRICS.on(cluster, msg));
        }
        this.stateManager.cacheLatestState(cluster, allState);
        return allState;
    }

    private void updateAllStateFromLatestState(String cluster, AllState allState) {
        AllState latestState = this.stateManager.getLatestState(cluster);
        if (latestState != null) {
            for (TimedMemberState timedMemberState : latestState.getTimedMemberStates()) {
                TimedMemberState latest = timedMemberState.clone();
                allState.addState(latest);
            }
        }
    }

    private void scheduleReadState(int chainId, MCClient client, Member member, Duration delay) {
        log.debug("Scheduling state read using client with id {} in chain {} for member {}", new Object[]{client.getClientId(), chainId, member});
        this.executorService.schedule(() -> {
            try {
                this.readState(chainId, client, member);
            }
            catch (Exception e) {
                log.error("Error reading state from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executorService);
    }

    int nextChainId(Member member) {
        return this.chainIdRegistry.nextId((Object)member);
    }

    @ConstructorProperties(value={"stateManager", "licenseManager", "nodeLimitStatus", "mcClientManager", "clusterManager", "notifier", "properties", "eventPublisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TimedMemberStateConsumer(StateManager stateManager, LicenseManager licenseManager, NodeLimitStatus nodeLimitStatus, MCClientManager mcClientManager, ClusterManager clusterManager, Notifier notifier, MetricsConfigurationProperties properties, ApplicationEventPublisher eventPublisher) {
        this.stateManager = stateManager;
        this.licenseManager = licenseManager;
        this.nodeLimitStatus = nodeLimitStatus;
        this.mcClientManager = mcClientManager;
        this.clusterManager = clusterManager;
        this.notifier = notifier;
        this.properties = properties;
        this.eventPublisher = eventPublisher;
    }
}

