/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.webmonitor.controller.dto.SetDTO;
import com.hazelcast.webmonitor.service.CollectionsStatsRegistry;
import com.hazelcast.webmonitor.service.MCClientManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SetStatsService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetStatsService.class);
    private final MCClientManager clientManager;
    private final CollectionsStatsRegistry collectionsStatsRegistry;

    public List<SetDTO> getClusterSets(String cluster) {
        HazelcastInstance hzClient = this.clientManager.clientFor(cluster).getHzClient();
        return this.collectionsStatsRegistry.getClusterSets(cluster).stream().peek(set -> {
            int size = hzClient.getSet(set.getName()).size();
            set.setSize(size);
        }).sorted(Comparator.comparing(SetDTO::getName)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"clientManager", "collectionsStatsRegistry"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SetStatsService(MCClientManager clientManager, CollectionsStatsRegistry collectionsStatsRegistry) {
        this.clientManager = clientManager;
        this.collectionsStatsRegistry = collectionsStatsRegistry;
    }
}

