/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.controller.exception.InvalidLicenseApiException;
import com.hazelcast.webmonitor.controller.exception.LicenseAlreadyConfiguredException;
import com.hazelcast.webmonitor.service.SettingsService;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.utils.LicenseHelperWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    public static final int UNLICENSED_CLUSTER_MEMBER_LIMIT = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseManager.class);
    private static final Feature[] BASIC_FEATURES = new Feature[]{Feature.MAN_CENTER, Feature.STREAMING_MAN_CENTER};
    private final SettingsService settingsService;
    private final boolean licenseSetByProperty;
    private final LicenseHelperWrapper licenseHelperWrapper;
    private final StateManager stateManager;
    private License license;

    @Autowired
    public LicenseManager(MCConfigurationProperties properties, SettingsService settingsService, LicenseHelperWrapper licenseHelperWrapper, StateManager stateManager) {
        this.settingsService = settingsService;
        this.licenseHelperWrapper = licenseHelperWrapper;
        this.stateManager = stateManager;
        this.license = this.licenseHelperWrapper.getBuiltInLicense();
        if (this.license == null) {
            String key = properties.getLicense();
            boolean bl = this.licenseSetByProperty = key != null;
            if (!this.licenseSetByProperty) {
                key = settingsService.getLicenseKey().orElse(null);
            }
            if (key != null) {
                this.applyLicense(key);
            }
            if (this.licenseSetByProperty && !this.hasValidLicense()) {
                String msg = String.format("The license provided via property '%s' is %s.", EnvProperty.LICENSE, this.isLicenseConfigured() ? "expired" : "invalid");
                log.error(msg);
                throw new Error(msg);
            }
        } else {
            this.licenseSetByProperty = false;
            LOGGER.debug("This is an OEM version of Hazelcast Management Center.");
        }
    }

    public License getLicense() {
        this.ensureLicenseIsConfigured();
        return this.license;
    }

    private void ensureLicenseIsConfigured() {
        if (this.license == null) {
            throw new InvalidLicenseException("License is not configured!");
        }
    }

    public void persistLicenseKey(String key) throws InvalidLicenseException {
        if (this.isBuiltInLicense()) {
            throw new LicenseAlreadyConfiguredException("    License can not be changed. This is an OEM Version of Hazelcast\n    Management Center with no license checking.\n");
        }
        if (this.licenseSetByProperty) {
            throw new LicenseAlreadyConfiguredException("License has been configured by system property %s and cannot be changed.".formatted(EnvProperty.LICENSE.getSysPropName()));
        }
        InvalidLicenseException error = this.applyLicense(key);
        if (error != null) {
            throw new InvalidLicenseApiException(error.getMessage());
        }
        this.settingsService.saveLicenseKey(key);
    }

    public License checkLicensePerFeature(Feature feature) {
        if (this.isBuiltInLicense()) {
            return this.license;
        }
        return this.licenseHelperWrapper.checkLicenseKeyPerFeature(this.getLicense().getKey(), BuildInfo.getFullVersion(), new Feature[]{feature});
    }

    public void clearLicense() {
        this.license = null;
    }

    private InvalidLicenseException applyLicense(String key) {
        if ("clear".equals(key)) {
            this.clearLicense();
            return null;
        }
        try {
            this.license = this.licenseHelperWrapper.checkLicenseKeyPerFeature(key, BuildInfo.getFullVersion(), BASIC_FEATURES);
            return null;
        }
        catch (InvalidLicenseException e) {
            LOGGER.info("License Problem occurred:", (Throwable)e);
            return e;
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("License Problem occurred:", (Throwable)e);
            return new InvalidLicenseException(e.getMessage());
        }
    }

    public boolean hasValidLicense() {
        return this.isLicenseConfigured() && !this.licenseHelperWrapper.isExpired(this.license);
    }

    public boolean hasValidClusterLicense(String cluster) {
        try {
            return this.stateManager.getClusterLicense(cluster).isPresent();
        }
        catch (Exception error) {
            return false;
        }
    }

    public boolean isLicenseConfigured() {
        return this.license != null;
    }

    public boolean isBuiltInLicense() {
        return this.isLicenseConfigured() && this.licenseHelperWrapper.isBuiltInLicense(this.license);
    }

    public long getLicenseExpirationDate() {
        return this.isLicenseConfigured() ? this.license.getExpiryDate().toInstant().toEpochMilli() : -1L;
    }

    public boolean isAboveMemberLimit(String cluster, int numberOfMembers) {
        int memberLimit = this.hasValidLicense() ? this.license.getAllowedNumberOfNodes() : 3;
        return numberOfMembers > memberLimit && (!this.hasValidLicense() || !this.hasValidClusterLicense(cluster));
    }
}

