/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"hazelcast.mc.lock.skip"}, havingValue="false", matchIfMissing=true)
public class HomeDirectoryLocker
implements InitializingBean,
DisposableBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeDirectoryLocker.class);
    private static final String LOCK_FILE_NAME = "mc.lock";
    private final Path lockFilePath;

    public HomeDirectoryLocker(HomeDirectoryProvider provider) {
        this.lockFilePath = provider.get().resolve(LOCK_FILE_NAME);
    }

    public boolean lockExists() {
        return Files.exists(this.lockFilePath, new LinkOption[0]);
    }

    public void lock() {
        try {
            Files.createFile(this.lockFilePath, new FileAttribute[0]);
        }
        catch (Exception e) {
            log.warn("Could not create lock file.", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        if (this.lockExists()) {
            log.warn("Lock for home directory '{}' already exists. This may be an evidence of a previous unexpected stop or of multiple running Management Center applications configured for the same home directory.", (Object)this.lockFilePath.getParent());
        }
        this.lock();
    }

    public void destroy() {
        try {
            Files.deleteIfExists(this.lockFilePath);
        }
        catch (Exception e) {
            log.warn("Could not delete lock file.", (Throwable)e);
        }
    }
}

