/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.webmonitor.config.conditions.ConditionalOnBranding;
import com.hazelcast.webmonitor.config.properties.FlowConfigurationProperties;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.LicenseUpdatedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnBranding(value="flow")
public class FlowLicenseService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowLicenseService.class);
    private static final int FLOW_LICENSE_PERIOD_SECONDS = 30;
    private final int flowLicenseSendPeriodSeconds;
    private final LicenseManager licenseManager;
    private final FlowConfigurationProperties flowConfigurationProperties;
    private final RestTemplate restTemplate;
    private final ScheduledExecutorService executorService;

    @Autowired
    public FlowLicenseService(LicenseManager licenseManager, FlowConfigurationProperties flowConfigurationProperties, RestTemplate restTemplate) {
        this(licenseManager, flowConfigurationProperties, restTemplate, Integer.valueOf(30));
    }

    FlowLicenseService(LicenseManager licenseManager, FlowConfigurationProperties flowConfigurationProperties, RestTemplate restTemplate, Integer flowLicenseSendPeriodSeconds) {
        this.licenseManager = licenseManager;
        this.restTemplate = restTemplate;
        this.flowLicenseSendPeriodSeconds = flowLicenseSendPeriodSeconds;
        this.flowConfigurationProperties = flowConfigurationProperties;
        this.executorService = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("FlowLicense-%d").build());
        this.scheduleSendLicense();
    }

    @EventListener
    public void licenseUpdated(LicenseUpdatedEvent event) {
        this.scheduleSendLicense(event.getLicenseKey());
    }

    public void scheduleSendLicense(String licenseKey) {
        this.executorService.schedule(() -> {
            try {
                this.sendLicense(licenseKey);
            }
            catch (HttpClientErrorException e) {
                if (e.getStatusCode() == HttpStatus.BAD_REQUEST) {
                    log.warn("License is sent to Flow with the following error: {}", (Object)e.getResponseBodyAsString());
                } else {
                    log.error("Error sending license to Flow.", (Throwable)e);
                    this.scheduleSendLicense();
                }
            }
            catch (Exception e) {
                log.error("Error sending license to Flow.", (Throwable)e);
                this.scheduleSendLicense();
            }
        }, Duration.ofSeconds(this.flowLicenseSendPeriodSeconds).toMillis(), TimeUnit.MILLISECONDS);
    }

    void scheduleSendLicense() {
        if (this.licenseManager.isLicenseConfigured()) {
            this.scheduleSendLicense(this.licenseManager.getLicense().getKey());
        } else {
            log.warn("License is not configured.");
        }
    }

    private void sendLicense(String licenseKey) {
        String flowBaseUrl = this.flowConfigurationProperties.getInternalAddress();
        if (flowBaseUrl.isEmpty()) {
            return;
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(flowBaseUrl + "/api/flow/license", HttpMethod.POST, new HttpEntity((Object)licenseKey), String.class, new Object[0]);
        log.debug("License is sent to Flow successfully. Response: {}", (Object)responseEntity);
    }
}

