/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.management.dto.MCEventDTO;
import com.hazelcast.internal.management.events.EventMetadata;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.version.Version;
import com.hazelcast.webmonitor.events.ConfigUpdateEventStore;
import com.hazelcast.webmonitor.events.DiagnosticsConfigUpdatedEventStore;
import com.hazelcast.webmonitor.events.EventGroupingVisitor;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.WanEventStore;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.EventFactory;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EventsConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventsConsumer.class);
    public static final Version VERSION_5_0 = Version.of((int)5, (int)0);
    private static final long DEFAULT_RESCHEDULE_DELAY_MS = 1000L;
    private static final long DEFAULT_RESCHEDULE_ON_ERROR_DELAY_MS = 5000L;
    private static final Set<EventMetadata.EventType> TYPES_WITHOUT_UUID = EnumSet.of(EventMetadata.EventType.WAN_CONSISTENCY_CHECK_IGNORED, EventMetadata.EventType.WAN_CONFIGURATION_ADDED, EventMetadata.EventType.WAN_CONFIGURATION_EXTENDED, EventMetadata.EventType.ADD_WAN_CONFIGURATION_IGNORED);
    private final long rescheduleDelayMs;
    private final long rescheduleOnErrorDelayMs;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("EventsConsumer-%d").build());
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final MCClientManager mcClientManager;
    private final ClusterManager clusterManager;
    private final WanEventStore wanEventStore;
    private final ConfigUpdateEventStore configUpdateEventStore;
    private final DiagnosticsConfigUpdatedEventStore diagnosticsConfigUpdatedEventStore;

    @Autowired
    public EventsConsumer(MCClientManager mcClientManager, ClusterManager clusterManager, WanEventStore wanEventStore, ConfigUpdateEventStore configUpdateEventStore, DiagnosticsConfigUpdatedEventStore diagnosticsConfigUpdatedEventStore) {
        this(1000L, 5000L, mcClientManager, clusterManager, wanEventStore, configUpdateEventStore, diagnosticsConfigUpdatedEventStore);
    }

    EventsConsumer(long rescheduleDelayMs, long rescheduleOnErrorDelayMs, MCClientManager mcClientManager, ClusterManager clusterManager, WanEventStore wanEventStore, ConfigUpdateEventStore configUpdateEventStore, DiagnosticsConfigUpdatedEventStore diagnosticsConfigUpdatedEventStore) {
        this.rescheduleDelayMs = rescheduleDelayMs;
        this.rescheduleOnErrorDelayMs = rescheduleOnErrorDelayMs;
        this.mcClientManager = mcClientManager;
        this.clusterManager = clusterManager;
        this.wanEventStore = wanEventStore;
        this.configUpdateEventStore = configUpdateEventStore;
        this.diagnosticsConfigUpdatedEventStore = diagnosticsConfigUpdatedEventStore;
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        for (Member member : event.getJoinedMembers()) {
            this.scheduleNextPoll(this.nextChainId(member), client, member, 0L);
        }
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        Member member = event.getRemovedMember();
        int nextId = this.nextChainId(member);
        this.chainIdRegistry.cleanUp((Object)member, nextId);
    }

    @EventListener
    public void onClusterDisconnected(DisconnectedFromClusterEvent event) {
        for (Member member : event.getRemovedMembers()) {
            int nextId = this.nextChainId(member);
            this.chainIdRegistry.cleanUp((Object)member, nextId);
        }
    }

    private void pollEvents(int chainId, MCClient client, Member member) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        String cluster = client.getClusterName();
        log.debug("Requesting events from {} of cluster {}.", (Object)member, (Object)cluster);
        client.pollMCEvents(member).whenCompleteAsync((events, t) -> {
            if (t == null) {
                this.scheduleNextPoll(chainId, client, member, this.rescheduleDelayMs);
                List localEvents = this.processEvents(events, cluster, member);
                this.dispatchEvents(cluster, localEvents);
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                log.debug("Exception when requesting events from {} of cluster {}.", new Object[]{member, cluster, error});
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleNextPoll(chainId, client, member, this.rescheduleOnErrorDelayMs);
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                if (this.clusterManager.isClusterConnected(cluster)) {
                    log.error("Error when requesting events from {} of cluster {}. Stopped polling events from this member.", new Object[]{member, cluster, error});
                }
            }
        }, (Executor)this.executorService);
    }

    public List<AbstractEvent> processEvents(List<MCEventDTO> events, String cluster, Member member) {
        if (events.isEmpty()) {
            return Collections.emptyList();
        }
        log.info("Received {} events from {} of cluster {}.", new Object[]{events.size(), member, cluster});
        try {
            MemberIdentifier memberIdent = MemberIdentifier.of((String)cluster, (Member)member);
            boolean shouldSetUuid = !member.getVersion().asVersion().isGreaterOrEqual(VERSION_5_0);
            return events.stream().map(dto -> EventsConsumer.mapMCEventDTO((MemberIdentifier)memberIdent, (MCEventDTO)dto, (boolean)shouldSetUuid)).toList();
        }
        catch (Exception e) {
            log.warn("Could not process events from {} of cluster {}.", new Object[]{member, cluster, e});
            return Collections.emptyList();
        }
    }

    @VisibleForTesting
    void dispatchEvents(String cluster, List<AbstractEvent> events) {
        EventGroupingVisitor eventGroupingVisitor = new EventGroupingVisitor(this.wanEventStore, this.configUpdateEventStore, this.diagnosticsConfigUpdatedEventStore);
        events.forEach(event -> event.accept((EventVisitor)eventGroupingVisitor));
        eventGroupingVisitor.batchFinished(cluster);
    }

    private void scheduleNextPoll(int chainId, MCClient client, Member member, long delayMs) {
        this.executorService.schedule(() -> {
            try {
                this.pollEvents(chainId, client, member);
            }
            catch (Exception e) {
                log.error("Error reading events from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executorService);
    }

    private static AbstractEvent mapMCEventDTO(MemberIdentifier memberIdent, MCEventDTO dto, boolean shouldSetUuid) {
        Map data = EventsConsumer.readEventData((String)dto.getDataJson());
        EventMetadata.EventType eventType = EventMetadata.EventType.withCode((int)dto.getType());
        if (shouldSetUuid && (data.get("uuid") == null || "null".equals(data.get("uuid")))) {
            if (TYPES_WITHOUT_UUID.contains(eventType)) {
                data.put("uuid", UuidUtil.newUnsecureUuidString());
            } else {
                log.warn("Unexpected event {} from member {} without UUID with data: {}", new Object[]{eventType, memberIdent, data});
            }
        }
        return EventFactory.createEvent((MemberIdentifier)memberIdent, (long)dto.getTimestamp(), (EventMetadata.EventType)eventType, (Map)data);
    }

    int nextChainId(Member member) {
        return this.chainIdRegistry.nextId((Object)member);
    }

    static Map<String, Object> readEventData(String rawJson) {
        try {
            return (Map)SerializationUtil.OBJECT_MAPPER.readValue(rawJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Can't parse event data JSON", e);
        }
    }
}

