/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.client.ClientWithNearCacheDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.MetricsService;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.ClientNearCacheMetricsQueryFactory;
import com.hazelcast.webmonitor.metrics.utils.TimeUtil;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.ClientEndPointDTO;
import com.hazelcast.webmonitor.service.ClientNearCacheRegistry;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClientNearCacheStatsManager
implements MetricDataPointProcessor {
    private static final List<Long> SUMMARY_INTERVALS_IN_MINUTES = List.of(Long.valueOf(1L), Long.valueOf(5L), Long.valueOf(30L), Long.valueOf(60L));
    private static final int REGISTRY_MAX_SIZE = 10000;
    private static final int REGISTRY_TTL_MIN = 10;
    private final StateManager stateManager;
    private final MetricsService metricsService;
    private final Clock clock;
    private final ClientNearCacheRegistry nearCacheRegistry;

    public ClientNearCacheStatsManager(StateManager stateManager, MetricsService metricsService, Clock clock) {
        this.stateManager = stateManager;
        this.metricsService = metricsService;
        this.clock = clock;
        this.nearCacheRegistry = new ClientNearCacheRegistry(clock, 10000, 10);
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        return Metric.NEARCACHE_CREATION_TIME.getName().equals(dataPoint.getName());
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String clientName = (String)tags.get(Tag.CLIENT_NAME.getName());
        String clientUuid = (String)tags.get(Tag.CLIENT.getName());
        String structName = (String)tags.get(Tag.NAME.getName());
        if (clientUuid != null && structName != null) {
            this.nearCacheRegistry.register(memberIdent.getClusterName(), clientUuid, clientName, StringUtils.removeStart((String)structName, (String)"/hz/"), ClientNearCacheStatsManager.inferDataStructureType((String)structName));
        }
    }

    public List<ClientWithNearCacheDTO> getClientsByDataStructure(String cluster, String structName, InstanceType structType) {
        Map clients = this.stateManager.getStatsEnabledClients(cluster);
        if (clients.isEmpty()) {
            return Collections.emptyList();
        }
        return this.nearCacheRegistry.getClientsByStruct(cluster, structName, structType).stream().map(clientData -> {
            ClientEndPointDTO client = (ClientEndPointDTO)clients.get(clientData.uuid);
            if (client == null) {
                return null;
            }
            return ClientWithNearCacheDTO.builder().uuid(clientData.uuid).name(client.getName()).type(client.getClientType()).version(client.getClientVersion()).build();
        }).filter(Objects::nonNull).sorted(Comparator.comparing(ClientWithNearCacheDTO::getName)).collect(Collectors.toList());
    }

    public SortedSet<String> getDataStructuresByClient(String cluster, String clientUuid, InstanceType type) {
        return this.nearCacheRegistry.getStructsByClient(cluster, clientUuid, type);
    }

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String structName, InstanceType structType, long time) {
        return this.getClientsNearCacheSummaryStats(cluster, structName, structType, time, 0L);
    }

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String structName, InstanceType structType, long time, long interval) {
        long endTime = time == 0L ? this.clock.currentTimeMillis() : time - interval;
        return SUMMARY_INTERVALS_IN_MINUTES.stream().map(intv -> this.getClientsNearCacheIntervalStats(cluster, structName, structType, endTime, intv.longValue())).collect(Collectors.toList());
    }

    private ClientsNearCacheIntervalStatsDTO getClientsNearCacheIntervalStats(String cluster, String structName, InstanceType structType, long endTime, long intervalInMinutes) {
        SortedSet clientsData = this.nearCacheRegistry.getClientsByStruct(cluster, structName, structType);
        if (clientsData.isEmpty()) {
            return ClientsNearCacheIntervalStatsDTO.empty((long)intervalInMinutes);
        }
        long startTime = endTime - intervalInMinutes * TimeUtil.ONE_MINUTE_IN_MS;
        long hits = 0L;
        long misses = 0L;
        for (ClientNearCacheRegistry.ClientData clientData : clientsData) {
            ClientNearCacheMetricsQueryFactory queryFactory = new ClientNearCacheMetricsQueryFactory.Builder().cluster(cluster).clientUuid(clientData.uuid).clientName(clientData.name).instanceType(structType).name(structName).start(startTime).end(endTime).build();
            hits += this.metricsService.computeCounterAggregates(queryFactory.hitsQuery()).getIncrement();
            misses += this.metricsService.computeCounterAggregates(queryFactory.missesQuery()).getIncrement();
        }
        long total = hits + misses;
        double effectiveness = total == 0L ? 0.0 : (double)hits / (double)total;
        return new ClientsNearCacheIntervalStatsDTO(intervalInMinutes, hits, misses, effectiveness);
    }

    private static InstanceType inferDataStructureType(String rawDataStructureName) {
        if (rawDataStructureName.startsWith("/hz/")) {
            return InstanceType.CACHE;
        }
        return InstanceType.MAP;
    }
}

