/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.ldap;

import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.PersistentSecurityProviderConfig;
import com.hazelcast.webmonitor.security.spi.impl.ldap.LdapConfig;
import com.hazelcast.webmonitor.utils.KeystoreUtil;
import java.util.Properties;
import org.jdbi.v3.core.Jdbi;

public class ExistingKeystorePersistentLdapConfig
extends PersistentSecurityProviderConfig<LdapConfig> {
    private final Jdbi jdbi;
    private final String keystorePath;
    private final String keystorePass;
    private final String keystoreType;
    private final String keystoreProvider;

    public ExistingKeystorePersistentLdapConfig(Jdbi jdbi, GroupedSettingsDAO groupedSettingsDAO, String existingKeystorePath, String existingKeystorePass, String existingKeystoreType, String existingKeystoreProvider) {
        super(groupedSettingsDAO);
        this.jdbi = jdbi;
        this.keystorePath = existingKeystorePath;
        this.keystorePass = existingKeystorePass;
        this.keystoreType = existingKeystoreType;
        this.keystoreProvider = existingKeystoreProvider;
    }

    public LdapConfig get() {
        Properties props = super.getProperties();
        props.setProperty("password", KeystoreUtil.load((String)this.keystorePath, (String)this.keystorePass, (String)this.keystoreType, (String)this.keystoreProvider));
        return LdapConfig.fromProperties((Properties)props);
    }

    public void write(LdapConfig ldapConfig) {
        this.jdbi.useTransaction(handle -> {
            Properties props = ldapConfig.toPropertiesWithoutPassword();
            this.groupedSettingsDAO.saveTx(handle, "securityProvider", props);
            KeystoreUtil.store((String)this.keystorePath, (String)this.keystorePass, (String)ldapConfig.getPassword(), (String)this.keystoreType, (String)this.keystoreProvider);
        });
    }
}

