/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.SettingModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class SettingsDAO {
    private final Jdbi jdbi;

    public List<SettingModel> findAll() {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("SELECT name, setting_value FROM settings");){
                List list = query.mapToBean(SettingModel.class).list();
                return list;
            }
        });
    }

    public Optional<SettingModel> findByName(String name) {
        return (Optional)this.jdbi.withHandle(handle -> this.findByNameTx(handle, name));
    }

    private Optional<SettingModel> findByNameTx(Handle handle, String name) {
        try (Query query = handle.createQuery("SELECT name, setting_value FROM settings WHERE name = :name");){
            Optional optional = ((Query)query.bind("name", name)).mapToBean(SettingModel.class).findFirst();
            return optional;
        }
    }

    List<SettingModel> findByPrefix(String prefix) {
        String escaped = SettingsDAO.escapeLikeOperatorWildcards((String)prefix);
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("SELECT name, setting_value FROM settings WHERE name LIKE :prefix");){
                List list = ((Query)query.bind("prefix", escaped + "%")).mapToBean(SettingModel.class).list();
                return list;
            }
        });
    }

    public void insertOrUpdate(SettingModel setting) {
        this.jdbi.useHandle(handle -> this.insertOrUpdateTx(handle, setting));
    }

    public void insertOrUpdateTx(Handle handle, SettingModel setting) {
        try (Update update = handle.createUpdate("MERGE INTO settings (name, setting_value) VALUES ( :name, :settingValue )");){
            ((Update)update.bindBean((Object)setting)).execute();
        }
    }

    public void deleteByName(String name) {
        this.jdbi.useHandle(handle -> {
            try (Update update = handle.createUpdate("DELETE FROM settings WHERE name = :name");){
                ((Update)update.bind("name", name)).execute();
            }
        });
    }

    void deleteByPrefix(String prefix) {
        this.jdbi.useHandle(handle -> this.deleteByPrefixTx(handle, prefix));
    }

    void deleteByPrefixTx(Handle handle, String prefix) {
        String escapedPrefix = SettingsDAO.escapeLikeOperatorWildcards((String)prefix);
        try (Update update = handle.createUpdate("DELETE FROM settings WHERE name LIKE :prefix");){
            ((Update)update.bind("prefix", escapedPrefix + "%")).execute();
        }
    }

    private static String escapeLikeOperatorWildcards(String prefix) {
        return prefix.replace("%", "\\%").replace("_", "\\_");
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SettingsDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

