/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.SettingModel;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.springframework.stereotype.Repository;

@Repository
public class GroupedSettingsDAO {
    private static final String PREFIX_NAME_SEPARATOR = ".";
    private final Jdbi jdbi;
    private final SettingsDAO settingsDAO;

    public void save(String groupName, Properties properties) {
        this.jdbi.useTransaction(handle -> this.saveTx(handle, groupName, properties));
    }

    public void saveTx(Handle handle, String groupName, Properties properties) {
        this.settingsDAO.deleteByPrefixTx(handle, this.prefix(groupName));
        properties.stringPropertyNames().forEach(propertyName -> this.settingsDAO.insertOrUpdateTx(handle, new SettingModel(this.withPrefix(propertyName, groupName), properties.getProperty((String)propertyName))));
    }

    public Properties read(String groupName) {
        Properties properties = new Properties();
        List settings = this.settingsDAO.findByPrefix(this.prefix(groupName));
        settings.forEach(setting -> properties.setProperty(this.withoutPrefix(setting.getName(), groupName), setting.getSettingValue()));
        return properties;
    }

    public void delete(String groupName) {
        this.jdbi.useTransaction(handle -> this.deleteTx(handle, groupName));
    }

    public void deleteTx(Handle handle, String groupName) {
        this.settingsDAO.deleteByPrefixTx(handle, this.prefix(groupName));
    }

    private String prefix(String name) {
        return name + PREFIX_NAME_SEPARATOR;
    }

    private String withPrefix(String propertyName, String groupName) {
        return this.prefix(groupName) + propertyName;
    }

    private String withoutPrefix(String settingName, String groupName) {
        return settingName.substring(this.prefix(groupName).length());
    }

    @ConstructorProperties(value={"jdbi", "settingsDAO"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GroupedSettingsDAO(Jdbi jdbi, SettingsDAO settingsDAO) {
        this.jdbi = jdbi;
        this.settingsDAO = settingsDAO;
    }
}

