/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.metrics.TagsBuilder;
import com.hazelcast.webmonitor.prometheus.PrometheusExporterConfigurationProperties;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
class PrometheusMetricPrinterImplV2
extends PrometheusMetricPrinter {
    private static final Map<String, BigDecimal> UNITS_MULTIPLIERS = Map.of("ms", BigDecimal.valueOf(0.001), "us", BigDecimal.valueOf(1.0E-6), "ns", BigDecimal.valueOf(1.0E-9), "percent", BigDecimal.valueOf(0.01), "time", BigDecimal.valueOf(0.001));
    static final String HAZELCAST_METRICS_NAMESPACE = "hazelcast_";
    private final Map<String, PrometheusExporterConfigurationProperties.MetricMapping> metricsMapping;

    PrometheusMetricPrinterImplV2(boolean shouldPrintTimestamp, Collection<PrometheusExporterConfigurationProperties.MetricMapping> metricMappings) {
        super(shouldPrintTimestamp);
        this.metricsMapping = metricMappings.stream().collect(Collectors.toMap(PrometheusExporterConfigurationProperties.MetricMapping::from, Function.identity(), (a, b) -> b));
    }

    void printEntry(Appendable output, String metricName, Map<String, String> labels, String unit, double value, long timestamp) throws IOException {
        PrometheusExporterConfigurationProperties.MetricMapping metricMapping = (PrometheusExporterConfigurationProperties.MetricMapping)this.metricsMapping.get(metricName);
        if (metricMapping == null) {
            return;
        }
        String unitOverride = metricMapping.fromUnit();
        Map mappedLabels = PrometheusMetricPrinterImplV2.getMappedLabels(labels, (PrometheusExporterConfigurationProperties.MetricMapping)metricMapping);
        double mappedValue = PrometheusMetricPrinterImplV2.getMappedValue((String)unit, (String)unitOverride, (double)value);
        super.printEntry(output, metricName, mappedLabels, unit, mappedValue, timestamp);
    }

    private static Map<String, String> getMappedLabels(Map<String, String> labels, PrometheusExporterConfigurationProperties.MetricMapping metricMapping) {
        Map mappedLabels = labels;
        Map extraLabels = metricMapping.extraLabels();
        if (extraLabels != null) {
            mappedLabels = TagsBuilder.tagsBuilderFrom(labels).with(extraLabels).buildStringMap();
        }
        return mappedLabels;
    }

    private static double getMappedValue(String unit, String fromUnit, double value) {
        double mappedValue = value;
        if (null != fromUnit) {
            mappedValue = PrometheusMetricPrinterImplV2.multiplyByUnitMultiplier((double)mappedValue, (String)fromUnit);
        } else if (null != unit) {
            mappedValue = PrometheusMetricPrinterImplV2.multiplyByUnitMultiplier((double)mappedValue, (String)unit);
        }
        return mappedValue;
    }

    private static double multiplyByUnitMultiplier(double value, String unit) {
        BigDecimal unitMultiplier = (BigDecimal)UNITS_MULTIPLIERS.get(unit.toLowerCase());
        if (unitMultiplier != null) {
            return BigDecimal.valueOf(value).multiply(unitMultiplier).doubleValue();
        }
        return value;
    }

    void printMetricName(Appendable output, String metricName, String unit) throws IOException {
        PrometheusExporterConfigurationProperties.MetricMapping metricMapping = (PrometheusExporterConfigurationProperties.MetricMapping)this.metricsMapping.get(metricName);
        if (metricMapping == null) {
            return;
        }
        String mappedMetricName = metricMapping.to();
        super.printMetricName(output, mappedMetricName, unit);
    }

    void printNamespace(Appendable output) throws IOException {
        output.append("hazelcast_");
    }
}

