/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;

abstract class PrometheusMetricPrinter {
    private final boolean shouldPrintTimestamp;

    void printEntry(Appendable output, String metricName, Map<String, String> labels, String unit, double value, long timestamp) throws IOException {
        this.printMetricName(output, metricName, unit);
        output.append('{');
        this.printLabels(output, labels, unit);
        output.append('}').append(' ');
        this.printMetricValue(output, value);
        if (this.shouldPrintTimestamp) {
            this.printTimestamp(output.append(' '), timestamp);
        }
        output.append('\n');
    }

    void printMetricName(Appendable output, String metricName, String unit) throws IOException {
        this.printNamespace(output);
        this.printLabelName(output, metricName);
    }

    abstract void printNamespace(Appendable var1) throws IOException;

    void printLabels(Appendable output, Map<String, String> tags, String unit) throws IOException {
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            this.printLabel(output, tag.getKey(), tag.getValue());
        }
    }

    void printLabel(Appendable output, String key, String value) throws IOException {
        this.printLabelName(output, key);
        output.append('=').append('\"');
        this.printLabelValue(output, value);
        output.append('\"').append(',');
    }

    void printLabelName(Appendable output, String labelName) throws IOException {
        for (int i = 0; i < labelName.length(); ++i) {
            char ch = labelName.charAt(i);
            if (ch == '.' || ch == ':' || ch == '-') {
                output.append('_');
                continue;
            }
            output.append(ch);
        }
    }

    void printLabelValue(Appendable output, String labelValue) throws IOException {
        block5: for (int i = 0; i < labelValue.length(); ++i) {
            char c = labelValue.charAt(i);
            switch (c) {
                case '\\': {
                    output.append("\\\\");
                    continue block5;
                }
                case '\"': {
                    output.append("\\\"");
                    continue block5;
                }
                case '\n': {
                    output.append("\\n");
                    continue block5;
                }
                default: {
                    output.append(c);
                }
            }
        }
    }

    void printMetricValue(Appendable output, double metricValue) throws IOException {
        output.append(Double.toString(metricValue));
    }

    void printTimestamp(Appendable output, long time) throws IOException {
        output.append(Long.toString(time));
    }

    @ConstructorProperties(value={"shouldPrintTimestamp"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrometheusMetricPrinter(boolean shouldPrintTimestamp) {
        this.shouldPrintTimestamp = shouldPrintTimestamp;
    }
}

