/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.metrics.MetricsTraceLogger;
import com.hazelcast.webmonitor.prometheus.PrometheusEntry;
import com.hazelcast.webmonitor.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricsProvider;
import com.hazelcast.webmonitor.service.Licensed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrometheusExporterImpl
implements PrometheusExporter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusExporterImpl.class);
    static final String PROMETHEUS_RESPONSE_CONTENT_TYPE = "text/plain; version=0.0.4; charset=utf-8";
    private final boolean enabled;
    private final MetricsTraceLogger metricsTraceLogger;
    private final List<PrometheusMetricsProvider> providers;
    private final List<PrometheusMetricPrinter> printers;
    private volatile boolean loggedDisabledWarning;
    private volatile boolean requestReceived;

    public boolean isEnabled() {
        return this.enabled;
    }

    @Licensed
    public void printExport(HttpServletRequest request, HttpServletResponse response) {
        this.requestReceived = true;
        response.setContentType(PROMETHEUS_RESPONSE_CONTENT_TYPE);
        try (BufferedWriter out = new BufferedWriter(response.getWriter());){
            if (this.checkIfPrometheusExportIsDisabled(response, (Appendable)out)) {
                return;
            }
            for (PrometheusMetricsProvider provider : this.providers) {
                for (Map.Entry entry : provider.getResults()) {
                    PrometheusEntry.Key key = (PrometheusEntry.Key)entry.getKey();
                    PrometheusEntry.Value value = (PrometheusEntry.Value)entry.getValue();
                    for (PrometheusMetricPrinter printer : this.printers) {
                        printer.printEntry((Appendable)out, key.metric(), key.tags(), key.unit(), value.value(), value.time());
                    }
                    this.metricsTraceLogger.trace((String)key.tags().get("mc_cluster"), key.metric(), key.tags(), value.time(), value.value(), "Metric exported to Prometheus");
                }
            }
            out.flush();
            if (response.getWriter().checkError()) {
                log.error("Failed to export metrics to Prometheus");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkIfPrometheusExportIsDisabled(HttpServletResponse response, Appendable writer) throws IOException {
        if (!this.enabled) {
            String logMessage = "Prometheus exporter is disabled. It can be turned on by setting the system property " + EnvProperty.PROMETHEUS_EXPORTER_ENABLED.getSysPropName() + "=true";
            if (!this.loggedDisabledWarning) {
                log.warn(logMessage);
                this.loggedDisabledWarning = true;
            }
            response.setStatus(404);
            writer.append(logMessage);
            return true;
        }
        return false;
    }

    public boolean wasRequestReceived() {
        return this.requestReceived;
    }

    @ConstructorProperties(value={"enabled", "metricsTraceLogger", "providers", "printers"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrometheusExporterImpl(boolean enabled, MetricsTraceLogger metricsTraceLogger, List<PrometheusMetricsProvider> providers, List<PrometheusMetricPrinter> printers) {
        this.enabled = enabled;
        this.metricsTraceLogger = metricsTraceLogger;
        this.providers = providers;
        this.printers = printers;
    }
}

