/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;

/*
 * Exception performing whole class analysis ignored.
 */
final class DataPointFilter {
    private static final Predicate<MetricDataPoint> ALLOW_ALL = metricDataPoint -> true;

    private DataPointFilter() {
    }

    static Predicate<MetricDataPoint> allowAll() {
        return ALLOW_ALL;
    }

    static Predicate<MetricDataPoint> fromAllowDenyLists(Set<String> allowList, Set<String> denyList, Collection<PrometheusMetricPrinter> metricPrinters) {
        Predicate predicate = ALLOW_ALL;
        if (!allowList.isEmpty()) {
            predicate = predicate.and(DataPointFilter.createFormInsensitivePredicate(allowList, metricPrinters));
        }
        if (!denyList.isEmpty()) {
            predicate = predicate.and(Predicate.not(DataPointFilter.createFormInsensitivePredicate(denyList, metricPrinters)));
        }
        return predicate;
    }

    private static Predicate<MetricDataPoint> createFormInsensitivePredicate(Set<String> metricNames, Collection<PrometheusMetricPrinter> metricPrinters) {
        return dataPoint -> {
            if (metricNames.contains(dataPoint.getName())) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            for (PrometheusMetricPrinter printer : metricPrinters) {
                try {
                    printer.printMetricName((Appendable)sb, dataPoint.getName(), dataPoint.getUnit());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (metricNames.contains(sb.toString())) {
                    return true;
                }
                sb.setLength(0);
            }
            return false;
        };
    }
}

