/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.controller.dto.metrics.storage.MetricsStorageDiagnosticsDTO;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsSupplier;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.text.MessageFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

class RocksDBMetricsStorageStatsLogger
implements AutoCloseable,
InitializingBean {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBMetricsStorageStatsLogger.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final int LOGGING_INTERVAL = 1;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "MetricsStorageStats"));
    private final RocksDBMetricsStorageStatsSupplier diagnosticsDataSupplier;

    public void afterPropertiesSet() throws Exception {
        this.executor.scheduleAtFixedRate(() -> this.logDiagnosticsData(), 1L, 1L, TimeUnit.HOURS);
    }

    void logDiagnosticsData() {
        MetricsStorageDiagnosticsDTO data = this.diagnosticsDataSupplier.get();
        log.info(MessageFormat.format("{0}{0}Known time series: {1}{0}Tracked minute buckets: {2}{0}Number of persistence runs: {3}{0}Total persistence run time: {4}{0}Max persistence run time: {5}{0}Average persistence run time: {6}{0}Last hour average persistence run time: {7}{0}Total persisted minute buckets: {8}{0}Max persisted minute buckets per run: {9}{0}Average persisted minute buckets per run: {10}{0}Last hour average persisted minute buckets per run: {11}{0}Total dropped data points that arrived when the target minute bucket is no longer tracked, but not yet released(persisted) : {12}{0}Total evicted dangling minute series : {13}{0}Persistent store TTL: {14}{0}Persistent store size on disk: {15}{0}Data point memory compression ratio: {16,number,#.##}{0}", LINE_SEPARATOR, data.getKnownTimeSeries(), data.getTrackedMinuteBuckets(), data.getPersistenceRuns(), DurationFormatUtils.formatDurationHMS((long)data.getTotalPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getMaxPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getAvgPersistenceRunTimeInMs()), DurationFormatUtils.formatDurationHMS((long)data.getLastHourAvgPersistenceRunTimeInMs()), data.getTotalPersistedMinuteBuckets(), data.getMaxPersistedMinuteBucketsPerRun(), data.getAvgPersistedMinuteBucketsPerRun(), data.getLastHourAvgPersistedMinuteBucketsPerRun(), data.getTotalDroppedDataPoints(), data.getTotalEvictedDanglingMinuteSeries(), DurationFormatUtils.formatDuration((long)TimeUnit.SECONDS.toMillis(data.getPersistentStoreTTLSeconds()), (String)"HH:mm:ss"), FileUtils.byteCountToDisplaySize((long)data.getStorageSizeInBytes()), data.getDataPointMemoryCompressionRatio()));
    }

    @Override
    public void close() throws Exception {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executor);
    }

    @ConstructorProperties(value={"diagnosticsDataSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RocksDBMetricsStorageStatsLogger(RocksDBMetricsStorageStatsSupplier diagnosticsDataSupplier) {
        this.diagnosticsDataSupplier = diagnosticsDataSupplier;
    }
}

