/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.ClosedStorageException;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.IntegerSerde;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RegistryKeySerializer;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBLoader;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.StorageException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class RocksDBMetricsRegistry
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBMetricsRegistry.class);
    static final String STORE_SUBDIR = "registry";
    static final int KEY_BUFFER_SIZE_IN_BYTES = 0x100000;
    private static final byte REGISTRY_KEY_NIL_FLAG = 1;
    private static final ByteBuffer SEQUENCE_KEY_BYTE_BUFFER = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).put((byte)1).flip();
    private static final ThreadLocal<ByteBuffer> KEY_BUFFER_POOL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(0x100000).order(ByteOrder.BIG_ENDIAN));
    private static final ThreadLocal<ByteBuffer> VALUE_BUFFER_POOL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(4).order(ByteOrder.BIG_ENDIAN));
    private final Path path;
    private final RocksDB store;
    private final ReadOptions readOptions;
    private final WriteOptions writeOptions;
    private final AtomicInteger nextId;
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;

    RocksDBMetricsRegistry(Path dir) {
        RocksDBLoader.loadLibrary();
        this.path = dir.resolve("registry");
        this.store = RocksDBMetricsRegistry.openOrCreateStore((Path)this.path);
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions();
        this.nextId = new AtomicInteger(this.readNextIdFromStorage());
    }

    private int readNextIdFromStorage() {
        int result;
        ByteBuffer valueBuffer = ((ByteBuffer)VALUE_BUFFER_POOL.get()).clear();
        try {
            result = this.store.get(this.readOptions, SEQUENCE_KEY_BYTE_BUFFER.position(0), valueBuffer);
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        if (result == -1) {
            return 0;
        }
        return IntegerSerde.deserialize((ByteBuffer)valueBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int get(Metric metric, Map<Tag, String> tags) {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            ByteBuffer keyBuffer = ((ByteBuffer)KEY_BUFFER_POOL.get()).clear();
            ByteBuffer valueBuffer = ((ByteBuffer)VALUE_BUFFER_POOL.get()).clear();
            RegistryKeySerializer.serialize((Metric)metric, tags, (ByteBuffer)keyBuffer);
            int n = this.readMetricIdFromStorage(keyBuffer, valueBuffer);
            return n;
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    int register(String metric, Map<String, String> tags) {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            ByteBuffer keyBuffer = ((ByteBuffer)KEY_BUFFER_POOL.get()).clear();
            ByteBuffer valueBuffer = ((ByteBuffer)VALUE_BUFFER_POOL.get()).clear();
            RegistryKeySerializer.serialize((String)metric, tags, (ByteBuffer)keyBuffer);
            int metricIdFromStorage = this.readMetricIdFromStorage(keyBuffer, valueBuffer);
            if (metricIdFromStorage != -1) {
                int n = metricIdFromStorage;
                return n;
            }
            int metricId = this.nextId.getAndIncrement();
            IntegerSerde.serialize((int)metricId, (ByteBuffer)valueBuffer);
            this.store.put(this.writeOptions, keyBuffer.position(0), valueBuffer);
            int n = metricId;
            return n;
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private int readMetricIdFromStorage(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        int result;
        try {
            result = this.store.get(this.readOptions, keyBuffer, valueBuffer);
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        if (result == -1) {
            return -1;
        }
        return IntegerSerde.deserialize((ByteBuffer)valueBuffer);
    }

    @Override
    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ByteBuffer valueBuffer = (ByteBuffer)VALUE_BUFFER_POOL.get();
            IntegerSerde.serialize((int)this.nextId.get(), (ByteBuffer)valueBuffer);
            this.store.put(this.writeOptions, SEQUENCE_KEY_BYTE_BUFFER.position(0), valueBuffer);
            this.readOptions.close();
            this.writeOptions.close();
            this.store.flushWal(true);
            this.store.closeE();
        }
        catch (Exception e) {
            log.warn("Could not close metrics registry store {}.", (Object)this.path, (Object)e);
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    int size() {
        this.closeInProgressLock.readLock().lock();
        try {
            if (this.closed) {
                int n = -1;
                return n;
            }
            int n = this.nextId.get();
            return n;
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new ClosedStorageException();
        }
    }

    /*
     * Exception decompiling
     */
    private static RocksDB openOrCreateStore(Path path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

