/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.QueueMetricsQueryFactory;

public final class QueueMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    public QueueMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).addTag(Tag.NAME, builder.name).start(builder.start).end(builder.end);
    }

    public Query creationTimeQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_CREATION_TIME).build();
    }

    public Query ownedItemCountQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_OWNED_ITEM_COUNT).build();
    }

    public Query backupItemCountQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_BACKUP_ITEM_COUNT).build();
    }

    public Query minAgeQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_MIN_AGE).build();
    }

    public Query maxAgeQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_MAX_AGE).build();
    }

    public Query averageAgeQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_AVERAGE_AGE).build();
    }

    public Query numberOfOffersQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_OFFERS).build();
    }

    public Query numberOfRejectedOffersQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_REJECTED_OFFERS).build();
    }

    public Query numberOfPollsQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_POLLS).build();
    }

    public Query numberOfEmptyPollsQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_EMPTY_POLLS).build();
    }

    public Query numberOfOtherOperationsQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_OTHER_OPERATIONS).build();
    }

    public Query numberOfEventsQuery() {
        return this.queryBuilder.metric(Metric.QUEUE_NUMBER_OF_EVENTS).build();
    }
}

