/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.imdg.OperationServiceMetricsQueryFactory;

public final class OperationServiceMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    public OperationServiceMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).start(builder.start).end(builder.end);
    }

    public Query responseQueueSizeQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_RESPONSE_QUEUE_SIZE).build();
    }

    public Query operationExecutorQueueSizeQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_QUEUE_SIZE).build();
    }

    public Query runningOperationsCountQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_RUNNING_COUNT).build();
    }

    public Query remoteOperationCountQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_INVOCATIONS_PENDING).build();
    }

    public Query executedOperationCountQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_COMPLETED_COUNT).build();
    }

    public Query operationThreadCountQuery() {
        return this.queryBuilder.metric(Metric.OPERATION_PARTITION_THREAD_COUNT).build();
    }
}

