/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.aggregation;

import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.aggregation.GroupByAggregator;
import com.hazelcast.webmonitor.metrics.aggregation.MetricType;
import java.util.Arrays;

final class MedianAggregator
extends GroupByAggregator {
    private long[][] valuesPerGroup;
    private int seriesIndex;

    MedianAggregator() {
    }

    protected void combinePoint(long[] dest, int index, long value) {
        this.valuesPerGroup[index][this.seriesIndex] = value;
    }

    public DataPointSeries compute() {
        if (this.aggregatedSeries.isEmpty()) {
            return DataPointSeries.empty();
        }
        long[] times = this.unionTimePoints();
        long[] values = new long[times.length];
        int size = this.aggregatedSeries.size();
        this.valuesPerGroup = new long[times.length][size];
        this.seriesIndex = 0;
        for (DataPointSeries series : this.aggregatedSeries) {
            this.combineSeries(series, times, values);
            ++this.seriesIndex;
        }
        int middleLeft = size / 2 - 1;
        int middleRight = size / 2;
        MetricType type = MetricType.from((DataPointType)this.dataPointType);
        for (int i = 0; i < times.length; ++i) {
            Arrays.sort(this.valuesPerGroup[i]);
            values[i] = type.median(this.valuesPerGroup[i], middleLeft, middleRight, size);
        }
        return new DataPointSeries(times, values, DataPointType.DOUBLE);
    }
}

