/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricConsumer;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.controller.dto.jet.JetStatus;
import com.hazelcast.webmonitor.metrics.DataPointsReceivedEvent;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricsConsumer;
import com.hazelcast.webmonitor.metrics.MetricsStorage;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.ScheduledOperationChainRegistry;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.housekeeping.FreeDiskSpaceEvent;
import com.hazelcast.webmonitor.service.jet.JetMetricsService;
import com.hazelcast.webmonitor.utils.ExceptionUtil;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import com.hazelcast.webmonitor.utils.MemberUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MetricsConsumer
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsConsumer.class);
    private final ScheduledExecutorService executorService;
    private final ScheduledOperationChainRegistry<Member> chainIdRegistry = new ScheduledOperationChainRegistry();
    private final MetricsStorage metricsStorage;
    private final JetMetricsService jetMetricsService;
    private final ApplicationEventPublisher publisher;
    private final ClusterManager clusterManager;
    private final MCClientManager mcClientManager;
    private final LicenseManager licenseManager;
    private final MetricsConfigurationProperties properties;
    private final AtomicBoolean disablePersistence = new AtomicBoolean();

    public MetricsConsumer(MetricsStorage metricsStorage, JetMetricsService jetMetricsService, ApplicationEventPublisher publisher, ClusterManager clusterManager, MCClientManager mcClientManager, LicenseManager licenseManager, MetricsConfigurationProperties properties) {
        this.metricsStorage = metricsStorage;
        this.jetMetricsService = jetMetricsService;
        this.publisher = publisher;
        this.clusterManager = clusterManager;
        this.mcClientManager = mcClientManager;
        this.licenseManager = licenseManager;
        this.properties = properties;
        this.executorService = Executors.newScheduledThreadPool(properties.getConsumerThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat("MetricsConsumer-%d").build());
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        MCClient client = this.mcClientManager.clientFor(event.getCluster());
        for (Member member : event.getJoinedMembers()) {
            this.scheduleReadMetrics(this.chainIdRegistry.nextId((Object)member), client, member, 0L, Duration.ZERO);
        }
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        Member member = event.getRemovedMember();
        int nextId = this.chainIdRegistry.nextId((Object)member);
        this.chainIdRegistry.cleanUp((Object)member, nextId);
    }

    @EventListener
    public void onClusterDisconnected(DisconnectedFromClusterEvent event) {
        for (Member member : event.getRemovedMembers()) {
            int nextId = this.chainIdRegistry.nextId((Object)member);
            this.chainIdRegistry.cleanUp((Object)member, nextId);
        }
    }

    @EventListener
    public void handleDiskSpaceEvent(FreeDiskSpaceEvent event) {
        this.disablePersistence.set(event.getSource() == FreeDiskSpaceEvent.Status.DISK_SPACE_CRITICALLY_LOW);
    }

    private void readMetrics(int chainId, MCClient client, Member member, long seq) {
        if (!this.chainIdRegistry.sameAsCurrentId((Object)member, chainId)) {
            return;
        }
        int numberOfMembers = client.getHzClient().getCluster().getMembers().size();
        if (this.licenseManager.isAboveMemberLimit(client.getClusterName(), numberOfMembers)) {
            this.scheduleReadMetrics(chainId, client, member, seq, this.properties.getConsumerRescheduleOnErrorDelay());
            return;
        }
        String cluster = client.getClusterName();
        log.debug("Requesting metrics from {} of cluster {}.", (Object)member, (Object)cluster);
        client.readMetricsAsync(member, seq).whenCompleteAsync((resultSet, t) -> {
            if (t == null) {
                this.extractAndSaveMetrics(cluster, member, resultSet.collections());
                this.scheduleReadMetrics(chainId, client, member, resultSet.nextSequence(), this.properties.getConsumerRescheduleDelay());
            } else {
                Throwable error = ExceptionUtil.peelClientError((Throwable)t);
                log.debug("Exception when requesting metrics from {} of cluster {}.", new Object[]{member, cluster, error});
                if (ExceptionUtil.isRecoverableClientError((Throwable)error)) {
                    this.scheduleReadMetrics(chainId, client, member, seq, this.properties.getConsumerRescheduleOnErrorDelay());
                    return;
                }
                this.chainIdRegistry.cleanUp((Object)member, chainId);
                if (this.clusterManager.isClusterConnected(cluster)) {
                    log.error("Error reading metrics for {} from cluster {}. Stopped metrics collection for this member.", new Object[]{member, cluster, t});
                }
            }
        }, (Executor)this.executorService);
    }

    private void scheduleReadMetrics(int chainId, MCClient client, Member member, long seq, Duration delay) {
        this.executorService.schedule(() -> {
            try {
                this.readMetrics(chainId, client, member, seq);
            }
            catch (Exception e) {
                log.error("Error reading metrics from {} of cluster {}.", new Object[]{member, client.getClusterName(), e});
            }
        }, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void extractAndSaveMetrics(String cluster, Member member, List<Map.Entry<Long, byte[]>> collections) {
        String memberAddress = MemberUtil.getMemberAddress((Member)member);
        List metricDataPoints = MetricsConsumer.extractMetrics((String)memberAddress, collections);
        MemberIdentifier memberIdent = MemberIdentifier.of((String)cluster, (String)memberAddress);
        this.publisher.publishEvent((ApplicationEvent)new DataPointsReceivedEvent(memberIdent, metricDataPoints));
        if (this.disablePersistence.get()) {
            return;
        }
        if (this.clusterManager.getJetStatus(cluster) == JetStatus.ENABLED) {
            try {
                this.jetMetricsService.save(cluster, member, metricDataPoints);
            }
            catch (Exception e) {
                log.error("Could not store Jet metrics from {} of cluster {}.", new Object[]{member, cluster, e});
            }
        }
        try {
            this.metricsStorage.store(cluster, metricDataPoints);
        }
        catch (Exception e) {
            log.error("Could not store metrics from {} of cluster {}.", new Object[]{member, cluster, e});
        }
    }

    public static List<MetricDataPoint> extractMetrics(String memberAddress, List<Map.Entry<Long, byte[]>> collections) {
        MetricsCollector metricsCollector = new MetricsCollector(memberAddress);
        for (Map.Entry<Long, byte[]> collection : collections) {
            metricsCollector.setTime(collection.getKey().longValue());
            MetricsCompressor.extractMetrics((byte[])collection.getValue(), (MetricConsumer)metricsCollector);
        }
        return metricsCollector.getResult();
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executorService);
    }
}

