/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.wan.WanPublisherState;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.AddWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.MapWithWanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanConsistencyCheckResultDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanPublisherStatsDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanReplicationDTO;
import com.hazelcast.webmonitor.controller.dto.wan.WanSyncResultDTO;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseWANController;
import com.hazelcast.webmonitor.service.AddWanConfigResultDTO;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.WanReplicationManager;
import com.hazelcast.webmonitor.service.wan.WanReplicationConfigService;
import com.hazelcast.webmonitor.service.wan.WanReplicationStatsService;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class WANController
extends BaseWANController {
    @Autowired
    public WANController(StateManager stateManager, WanReplicationManager wanReplicationManager, WanReplicationStatsService wanStatsService, WanReplicationConfigService wanReplicationConfigService, AuditLogService auditService) {
        super(stateManager, wanReplicationManager, wanStatsService, wanReplicationConfigService, auditService);
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications"})
    public List<WanReplicationDTO> getWanReplications(@PathVariable String cluster, @RequestParam(required=false) String replication, @RequestParam(required=false) String publisher) {
        return this.getWanReplicationsInternal(cluster, replication, publisher);
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications/{replication}/publishers/{publisher}"})
    public WanPublisherStatsDTO getPublisher(@PathVariable String cluster, @PathVariable String replication, @PathVariable String publisher) {
        return this.getPublisherInternal(cluster, replication, publisher);
    }

    @GetMapping(path={"/clusters/{cluster}/wanReplications/{replication}/maps"})
    public List<MapWithWanReplicationDTO> getMaps(@PathVariable String cluster, @PathVariable String replication) {
        return this.getMapsInternal(cluster, replication);
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public AddWanConfigResultDTO addWanReplication(@PathVariable String cluster, @Valid @RequestBody AddWanReplicationDTO wanReplication, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        return this.addWanReplicationInternal(cluster, wanReplication);
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/checkConsistency"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public WanConsistencyCheckResultDTO startWanConsistencyCheck(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam String syncMap) {
        return this.startWanConsistencyCheckInternal(cluster, wanReplication, publisher, syncMap);
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/sync"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public WanSyncResultDTO startWanMapSync(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam(required=false) String syncMap) {
        return this.startWanMapSyncInternal(cluster, wanReplication, publisher, syncMap);
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/changeState"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void changeWanState(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam WanPublisherState state, @RequestParam(required=false) String member) {
        this.changeWanStateInternal(cluster, wanReplication, publisher, state, member);
    }

    @PostMapping(path={"/clusters/{cluster}/wanReplications/{wanReplication}/publishers/{publisher}/clearQueues"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void clearQueues(@PathVariable String cluster, @PathVariable String wanReplication, @PathVariable String publisher, @RequestParam String member) {
        this.clearQueuesInternal(cluster, wanReplication, publisher, member);
    }
}

