/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.license.domain.License;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.license.LicenseInfoDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.LicenseUpdatedEvent;
import com.hazelcast.webmonitor.service.StateManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class LicenseController
extends BaseInternalController {
    private final LicenseManager licenseManager;
    private final ApplicationEventPublisher publisher;

    @Autowired
    public LicenseController(StateManager stateManager, LicenseManager licenseManager, AuditLogService auditService, ApplicationEventPublisher publisher) {
        super(stateManager, auditService);
        this.licenseManager = licenseManager;
        this.publisher = publisher;
    }

    @GetMapping(path={"/license"})
    public LicenseInfoDTO getMCLicense() {
        try {
            return LicenseInfoDTO.mcLicense((License)this.licenseManager.getLicense(), (boolean)this.licenseManager.isBuiltInLicense());
        }
        catch (InvalidLicenseException e) {
            return LicenseInfoDTO.notConfigured();
        }
    }

    @PostMapping(path={"/license"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateMCLicense(@RequestParam String key) {
        this.licenseManager.persistLicenseKey(key);
        this.publisher.publishEvent((ApplicationEvent)new LicenseUpdatedEvent(key));
        this.auditService.log(this.configLogBuilder("MC-0009 [Config]", "Configure MC License").build());
    }
}

