/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.console;

import com.hazelcast.internal.util.UuidUtil;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Console.class);
    private static final Integer KILL_TIMEOUT = 10;
    private static final String NONINTERACTIVE_CLC_COMMANDS = "atomiclong:*,list:*,map:*,multimap:*,object:*,queue:*,set:*,topic:*,cpmap:*,atomicreference:*,def,sql:*,config:add,config:import-java,shell:*";
    private static final String INTERACTIVE_CLC_COMMANDS = "atomiclong:*,list:*,map:*,multimap:*,object:*,queue:*,set:*,topic:*,cpmap:*,atomicreference:*,def,sql:*,shell:*";
    private final String uuid = UuidUtil.newUnsecureUuidString();
    private final Integer commandTimeoutSeconds;
    private final PtyProcessBuilder builder;
    private PtyProcess process;

    public Console(String clusterId, String homeDirectory, String command, boolean isInteractive, int commandTimeoutSeconds) {
        this.commandTimeoutSeconds = commandTimeoutSeconds;
        this.builder = new PtyProcessBuilder().setEnvironment(Map.of("SYSTEMROOT", System.getenv("SYSTEMROOT") == null ? "" : System.getenv("SYSTEMROOT"), "CLC_COMMAND_WHITE_LIST", isInteractive ? INTERACTIVE_CLC_COMMANDS : NONINTERACTIVE_CLC_COMMANDS, "CLC_HOME", homeDirectory, "CLC_CONFIG", clusterId, "CLC_CLIENT_NAME", "MC-CLC-" + this.uuid, "CLC_MAX_COLS", "150", "HZ_PHONE_HOME_ENABLED", "false", "CLC_SKIP_UPDATE_CHECK", "1")).setCommand(command.split(" "));
    }

    boolean start() {
        try {
            if (this.process == null) {
                this.process = this.builder.start();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    void destroy() {
        try {
            if (this.process != null && this.process.isAlive()) {
                this.process.destroy();
                this.process.getOutputStream().close();
                this.process.getInputStream().close();
                boolean processKilled = this.process.waitFor((long)KILL_TIMEOUT.intValue(), TimeUnit.SECONDS);
                if (!processKilled) {
                    this.process.destroyForcibly().waitFor();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to destroy console instance {}.", (Object)this.uuid);
            Thread.currentThread().interrupt();
        }
    }

    synchronized void write(String input) {
        try {
            this.process.getOutputStream().write(input.getBytes(StandardCharsets.UTF_8));
            this.process.getOutputStream().flush();
        }
        catch (IOException e) {
            log.debug("Failed to pipe user input {} to console instance {}", (Object)input, (Object)this.uuid);
        }
    }

    void waitFor() {
        try {
            this.process.waitFor((long)this.commandTimeoutSeconds.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getCommandTimeoutSeconds() {
        return this.commandTimeoutSeconds;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PtyProcessBuilder getBuilder() {
        return this.builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PtyProcess getProcess() {
        return this.process;
    }
}

