/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.configreplacer;

import com.hazelcast.webmonitor.utils.ReflectionUtil;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ConfigReplacerHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigReplacerHelper.class);
    public static final String CONFIG_REPLACER_CLASS_SYS_PROP = "hazelcast.mc.configReplacer.class";
    public static final String CONFIG_REPLACER_FAIL_FAST_SYS_PROP = "hazelcast.mc.configReplacer.failIfValueMissing";
    private static Object replacer;
    private static boolean failFast;
    private static boolean enabled;

    public static void init() {
        String className = System.getProperty("hazelcast.mc.configReplacer.class");
        boolean bl = enabled = !StringUtil.isNullOrEmptyAfterTrim((String)className);
        if (enabled) {
            try {
                Class<?> replacerClass = Class.forName(className);
                replacer = replacerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.warn("Class not found - [{}]. Make sure it is on the classpath.", (Object)className, (Object)e);
                enabled = false;
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("Failed to initialize ConfigReplacer with class [{}]", (Object)className, (Object)e);
                enabled = false;
            }
        }
        if (enabled) {
            failFast = Boolean.parseBoolean(System.getProperty("hazelcast.mc.configReplacer.failIfValueMissing", "true"));
            try {
                ReflectionUtil.invokeMethod((Object)replacer, (String)"init", (Object)System.getProperties());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Failed to initialize ConfigReplacer with class [{}]", (Object)className, (Object)e);
                enabled = false;
            }
        }
    }

    public static String replace(String key, String value) {
        if (!enabled || value == null) {
            return value;
        }
        try {
            StringBuilder sb = new StringBuilder(value);
            String replacerPrefix = "$" + String.valueOf(ReflectionUtil.invokeMethod((Object)replacer, (String)"getPrefix")) + "{";
            int startIndex = sb.indexOf(replacerPrefix);
            while (startIndex > -1) {
                int endIndex = sb.indexOf("}", startIndex);
                if (endIndex == -1) {
                    log.warn("Bad variable syntax. Could not find a closing curly bracket '}' for prefix {} on key: {}", (Object)replacerPrefix, (Object)key);
                    break;
                }
                String variable = sb.substring(startIndex + replacerPrefix.length(), endIndex);
                String variableReplacement = (String)ReflectionUtil.invokeMethod((Object)replacer, (String)"getReplacement", (Object)variable);
                if (variableReplacement != null) {
                    sb.replace(startIndex, endIndex + 1, variableReplacement);
                    endIndex = startIndex + variableReplacement.length();
                } else {
                    ConfigReplacerHelper.handleMissingVariable((String)sb.substring(startIndex, endIndex + 1), (String)key, (boolean)failFast);
                }
                startIndex = sb.indexOf(replacerPrefix, endIndex);
            }
            return sb.toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return value;
        }
    }

    public static Properties replace(Properties in) {
        Properties out = new Properties();
        for (String key : in.stringPropertyNames()) {
            out.setProperty(key, ConfigReplacerHelper.replace((String)key, (String)in.getProperty(key)));
        }
        return out;
    }

    private static void handleMissingVariable(String variable, String key, boolean failFast) {
        String message = String.format("Could not find a replacement for '%s' on key '%s'", variable, key);
        if (failFast) {
            throw new RuntimeException(message);
        }
        log.warn(message);
    }

    private ConfigReplacerHelper() {
    }

    static {
        ConfigReplacerHelper.init();
    }
}

