/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import java.io.PrintWriter;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Configure DevMode Security Provider. No Security Provider should be already configured when using this task. If you need to overwrite security provider configuration, use 'security reset' task first.%n*Important notice* Make sure that Management Center web application is stopped (offline) before starting this task.%n"}, mixinStandardHelpOptions=true, sortOptions=false)
public class ConfigureDevModeTask
extends BaseCliTask {
    public ConfigureDevModeTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityManager = new SecurityConfigurationManager(settingsDAO);
        if (securityManager.getCurrentSecurityProviderName() != null) {
            throw new CliException("Security Provider is already configured. Use 'security reset' task first, if you want to set up new security provider.");
        }
        securityManager.setCurrentSecurityProviderName("Dev Mode");
        this.printf("Successfully set up DevMode security provider.%n", new Object[0]);
    }
}

