/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.Base64StoresSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Base64StoresSSLContextFactory
implements SSLContextFactory {
    private final AtomicBoolean logTheWarning = new AtomicBoolean(true);
    protected static final String PROP_KEY_MATERIAL_DURATION = "keyMaterialDuration";
    protected static final String PROP_PROTOCOL = "protocol";
    protected static final String PROP_TRUST_STORE_TYPE = "trustStoreType";
    protected static final String PROP_TRUST_MANAGER_ALGORITHM = "trustManagerAlgorithm";
    protected static final String PROP_TRUST_STORE_PASSWORD = "trustStorePassword";
    protected static final String PROP_TRUST_STORE = "trustStore";
    protected static final String PROP_KEY_STORE_TYPE = "keyStoreType";
    protected static final String PROP_KEY_MANAGER_ALGORITHM = "keyManagerAlgorithm";
    protected static final String PROP_KEY_STORE = "keyStore";
    protected static final String PROP_KEY_STORE_PASSWORD = "keyStorePassword";
    protected final Properties properties = new Properties();
    protected volatile String protocol;
    protected volatile Duration keyMaterialDuration;
    protected volatile String keyStorePassword;
    protected volatile String keyStore;
    protected volatile String keyManagerAlgorithm;
    protected volatile String keyStoreType;
    protected volatile String trustStore;
    protected volatile String trustStorePassword;
    protected volatile String trustManagerAlgorithm;
    protected volatile String trustStoreType;
    private volatile KeyMaterialHolder keyMaterial;

    public void init(Properties properties) throws Exception {
        this.load(properties);
        SSLContext.getInstance(this.protocol);
    }

    public SSLContext getSSLContext() {
        try {
            SSLEngineFactorySupport.KeyMaterial km = this.getKeyMaterial();
            TrustManagerFactory tmf = km.getTrustManagerFactory();
            KeyManagerFactory kmf = km.getKeyManagerFactory();
            if (tmf == null && this.logTheWarning.getAndSet(false)) {
                Logger.getLogger(this.getClass()).warning("The trustStore is not configured in Hazelcast TLS/SSL configuration! Java platform default will be used. This can reduce the security level provided.");
            }
            KeyManager[] keyManagers = kmf == null ? null : kmf.getKeyManagers();
            TrustManager[] trustManagers = tmf == null ? null : tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void load(Properties properties) throws Exception {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
        this.keyStorePassword = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"keyStorePassword");
        this.keyStore = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"keyStore");
        this.keyManagerAlgorithm = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"keyManagerAlgorithm", (String)KeyManagerFactory.getDefaultAlgorithm());
        String defaultKeyStoreType = KeyStore.getDefaultType();
        this.keyStoreType = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"keyStoreType", (String)defaultKeyStoreType);
        this.trustStore = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"trustStore");
        this.trustStorePassword = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"trustStorePassword");
        this.trustManagerAlgorithm = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"trustManagerAlgorithm", (String)TrustManagerFactory.getDefaultAlgorithm());
        this.trustStoreType = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"trustStoreType", (String)defaultKeyStoreType);
        this.protocol = SSLEngineFactorySupport.getProperty((Properties)properties, (String)"protocol", (String)"TLS");
        this.keyMaterialDuration = Duration.parse(SSLEngineFactorySupport.getProperty((Properties)properties, (String)"keyMaterialDuration", (String)"PT-1S"));
        this.keyMaterial = this.keyMaterialDuration.isNegative() ? new KeyMaterialHolder(Instant.MAX, Base64StoresSSLContextFactory.loadKeyManagerFactory((String)this.keyStorePassword, (String)this.keyStore, (String)this.keyManagerAlgorithm, (String)this.keyStoreType), Base64StoresSSLContextFactory.loadTrustManagerFactory((String)this.trustStorePassword, (String)this.trustStore, (String)this.trustManagerAlgorithm, (String)this.trustStoreType)) : new KeyMaterialHolder(Instant.MIN, null, null);
    }

    public SSLEngineFactorySupport.KeyMaterial getKeyMaterial() throws IOException, GeneralSecurityException {
        if (this.keyMaterialDuration.isNegative()) {
            return this.keyMaterial;
        }
        KeyMaterialHolder tmpKeyMaterial = this.keyMaterial;
        if (!tmpKeyMaterial.isValid()) {
            KeyManagerFactory kmf = Base64StoresSSLContextFactory.loadKeyManagerFactory((String)this.keyStorePassword, (String)this.keyStore, (String)this.keyManagerAlgorithm, (String)this.keyStoreType);
            TrustManagerFactory tmf = Base64StoresSSLContextFactory.loadTrustManagerFactory((String)this.trustStorePassword, (String)this.trustStore, (String)this.trustManagerAlgorithm, (String)this.trustStoreType);
            tmpKeyMaterial = new KeyMaterialHolder(Instant.now().plus(this.keyMaterialDuration), kmf, tmf);
            if (!this.keyMaterialDuration.isZero()) {
                this.keyMaterial = tmpKeyMaterial;
            }
        }
        return tmpKeyMaterial;
    }

    public static TrustManagerFactory loadTrustManagerFactory(String trustStorePassword, String trustStore, String trustManagerAlgorithm, String trustStoreType) throws IOException, GeneralSecurityException {
        if (trustStore == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        KeyStore ts = KeyStore.getInstance(trustStoreType);
        char[] passPhrase = trustStorePassword == null ? null : trustStorePassword.toCharArray();
        Base64StoresSSLContextFactory.loadKeyStore((KeyStore)ts, (char[])passPhrase, (String)trustStore);
        tmf.init(ts);
        return tmf;
    }

    public static KeyManagerFactory loadKeyManagerFactory(String keyStorePassword, String keyStore, String keyManagerAlgorithm, String keyStoreType) throws IOException, GeneralSecurityException {
        if (keyStore == null) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        char[] passPhrase = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        Base64StoresSSLContextFactory.loadKeyStore((KeyStore)ks, (char[])passPhrase, (String)keyStore);
        kmf.init(ks, passPhrase);
        return kmf;
    }

    public static void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(keyStoreFile));){
            ks.load(in, passPhrase);
        }
    }
}

