CREATE TABLE IF NOT EXISTS users (
    username VARCHAR(255) PRIMARY KEY,
    last_login_time TIMESTAMP,
    current_login_time TIMESTAMP
);

CREATE TABLE IF NOT EXISTS user_credentials (
    username VARCHAR(255) PRIMARY KEY,
    password VARCHAR(255) NOT NULL,
    role VARCHAR(255) NOT NULL,
    FOREIGN KEY (username) REFERENCES users (username)
);

CREATE TABLE IF NOT EXISTS settings (
    name VARCHAR(255) PRIMARY KEY,
    value VARCHAR(255)
);

CREATE TABLE IF NOT EXISTS scripts (
    username VARCHAR(255),
    script_name VARCHAR(255),
    language VARCHAR(50) NOT NULL,
    code CLOB NOT NULL,
    PRIMARY KEY(username, script_name),
    FOREIGN KEY (username) REFERENCES users (username)
);
