@ECHO OFF

SET SCRIPT_DIR=%~dp0

if "x%JAVA_HOME%" == "x" (
    set RUN_JAVA=java
) else (
    set "RUN_JAVA=%JAVA_HOME%\bin\java"
)

SET USER_LIB=%SCRIPT_DIR%user-lib

IF "%MC_CLASSPATH%" NEQ "" (
    SET MC_CLASSPATH=%MC_CLASSPATH:;=,%,%USER_LIB%
) ELSE (
    SET MC_CLASSPATH=%USER_LIB%
)

REM Upgrade H2 database before running conf
SET H2_UPGRADE_JAR=%SCRIPT_DIR%..\h2-upgrade-cli-5.10.0.jar
IF EXIST "%H2_UPGRADE_JAR%" (
    "%RUN_JAVA%" %JAVA_OPTS% -Dcom.sun.jndi.ldap.object.trustSerialData=false -jar "%H2_UPGRADE_JAR%" upgrade --silent-start
)

"%RUN_JAVA%" -Dloader.path=%MC_CLASSPATH% %JAVA_OPTS% -Dloader.main=com.hazelcast.webmonitor.cli.MCConfCommandLine -Dcom.sun.jndi.ldap.object.trustSerialData=false -cp %SCRIPT_DIR%\..\hazelcast-management-center-5.10.0.jar org.springframework.boot.loader.launch.PropertiesLauncher %*
