/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.hazelcast.sql.SqlService;
import com.hazelcast.webmonitor.config.properties.CloudSQLWizardConfigurationProperties;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.sql.dto.SQLWizardConnectorConfigDTO;
import com.hazelcast.webmonitor.sql.dto.SQLWizardDemoConfigDTO;
import com.hazelcast.webmonitor.sql.dto.SQLWizardFrontendDemoConfigDTO;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Profile(value={"hzcloud"})
public class CloudSqlWizardConfigManager
implements InitializingBean,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudSqlWizardConfigManager.class);
    static final List<SQLWizardConnectorConfigDTO> DEFAULT_CONNECTOR_CONFIG = List.of(SQLWizardConnectorConfigDTO.builder().id(String.valueOf(SQLWizardConnectorConfigDTO.ConnectorType.IMAP)).type(SQLWizardConnectorConfigDTO.ConnectorType.IMAP).build());
    private final AtomicReference<List<SQLWizardConnectorConfigDTO>> connectorConfigs = new AtomicReference<List>(DEFAULT_CONNECTOR_CONFIG);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private List<SQLWizardFrontendDemoConfigDTO> frontendDemoConfigs = Collections.emptyList();
    private Map<String, List<String>> demoConnectionStatements = Collections.emptyMap();
    private Map<String, List<String>> demoSqlStatements = Collections.emptyMap();
    private final MCClientManager clientManager;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "WizardConfigsLoader"));
    private final RestTemplate restTemplate;
    private final CloudSQLWizardConfigurationProperties sqlWizardProperties;
    private final Validator validator;

    public CloudSqlWizardConfigManager(MCClientManager mcClientManager, RestTemplate cloudSqlWizardRestTemplate, CloudSQLWizardConfigurationProperties sqlWizardProperties) {
        this.clientManager = mcClientManager;
        this.sqlWizardProperties = sqlWizardProperties;
        this.restTemplate = cloudSqlWizardRestTemplate;
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduler.scheduleAtFixedRate(() -> this.loadConnectors(), 0L, 1L, TimeUnit.MINUTES);
        this.scheduler.scheduleAtFixedRate(() -> this.loadDemos(), 0L, 1L, TimeUnit.MINUTES);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void loadConnectors() {
        ResponseEntity response;
        try {
            response = this.restTemplate.exchange(this.sqlWizardProperties.getConnectorsUrl(), HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Couldn't load SQL wizard connector configs", (Throwable)e);
            return;
        }
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.warn("Couldn't load SQL wizard connector configs. HTTP response status code={}", (Object)response.getStatusCode().value());
            return;
        }
        @Valid List body = (List)response.getBody();
        if (body == null || body.isEmpty()) {
            log.warn("Couldn't load SQL wizard connector configs. Config is null or empty");
            return;
        }
        Set violations = body.stream().flatMap(it -> this.validator.validate(it, new Class[0]).stream()).collect(Collectors.toUnmodifiableSet());
        if (!violations.isEmpty()) {
            log.warn("Couldn't load SQL wizard connector configs", (Throwable)new ConstraintViolationException(violations));
            return;
        }
        Set idSet = body.stream().map(SQLWizardConnectorConfigDTO::getId).collect(Collectors.toSet());
        if (idSet.size() != body.size()) {
            log.warn("Couldn't load SQL wizard connector configs. IDs should be unique.");
            return;
        }
        List previous = (List)this.connectorConfigs.get();
        if (!body.equals(previous)) {
            log.info("New SQL wizard connector configs are loaded");
        }
        this.connectorConfigs.set(body);
    }

    public List<SQLWizardConnectorConfigDTO> getConnectorConfigs() {
        return (List)this.connectorConfigs.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDemos() {
        ResponseEntity response;
        try {
            response = this.restTemplate.getForEntity(this.sqlWizardProperties.getDemosUrl(), SQLWizardDemoConfigDTO.class, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Couldn't load SQL wizard demo configs", (Throwable)e);
            return;
        }
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.warn("Couldn't load SQL wizard demo configs. HTTP response status code={}", (Object)response.getStatusCode().value());
            return;
        }
        SQLWizardDemoConfigDTO body = (SQLWizardDemoConfigDTO)response.getBody();
        if (body == null) {
            log.warn("Couldn't load SQL wizard demo configs. Config is null");
            return;
        }
        Set violations = this.validator.validate((Object)body, new Class[0]);
        if (!violations.isEmpty()) {
            log.warn("Couldn't load SQL wizard demo configs", (Throwable)new ConstraintViolationException(violations));
            return;
        }
        String unknownConnectionNames = body.getDemos().stream().flatMap(demo -> demo.getConnections().stream()).filter(Predicate.not(body.getConnections()::containsKey)).collect(Collectors.joining(", "));
        if (!unknownConnectionNames.isBlank()) {
            log.warn("Couldn't load SQL wizard demo configs. Unknown connection names in demos: {}", (Object)unknownConnectionNames);
            return;
        }
        this.rwLock.writeLock().lock();
        try {
            List demos = body.getDemos().stream().map(SQLWizardDemoConfigDTO.DemoSettings::toFrontendDTO).collect(Collectors.toUnmodifiableList());
            List previous = this.frontendDemoConfigs;
            if (!demos.equals(previous)) {
                log.info("New SQL wizard demo configs are loaded");
            }
            this.frontendDemoConfigs = demos;
            this.demoConnectionStatements = body.getDemos().stream().collect(Collectors.toMap(SQLWizardDemoConfigDTO.DemoSettings::getId, demo -> demo.getConnections().stream().map(connectionName -> (String)body.getConnections().get(connectionName)).collect(Collectors.toUnmodifiableList())));
            this.demoSqlStatements = body.getDemos().stream().collect(Collectors.toMap(SQLWizardDemoConfigDTO.DemoSettings::getId, SQLWizardDemoConfigDTO.DemoSettings::getSqlStatements));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public List<SQLWizardFrontendDemoConfigDTO> getFrontendDemoConfigs() {
        this.rwLock.readLock().lock();
        try {
            List list = this.frontendDemoConfigs;
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDemo(String cluster, String id) {
        List sqlStatements;
        List connections;
        this.rwLock.readLock().lock();
        try {
            connections = (List)this.demoConnectionStatements.get(id);
            sqlStatements = (List)this.demoSqlStatements.get(id);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        SqlService sqlService = this.clientManager.clientFor(cluster).getHzClient().getSql();
        for (String sql : connections) {
            sqlService.executeUpdate(sql, new Object[0]);
        }
        for (String sql : sqlStatements) {
            sqlService.executeUpdate(sql, new Object[0]);
        }
    }

    @Override
    public void close() throws Exception {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.scheduler);
    }
}

