/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.TopicStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.TopicMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class TopicMXBeanImpl
implements TopicMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Topics";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile TopicStatsDTO stats;

    public TopicMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getTopicStats(this.cluster, this.name, InstanceType.TOPIC);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, TopicStatsDTO::getCreationTime);
    }

    public long getTotalPublishes() {
        return MXBeanHelper.safeGet((Object)this.stats, TopicStatsDTO::getTotalPublishes);
    }

    public long getReceiveOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, TopicStatsDTO::getTotalReceivedMessages);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

