/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.MapStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.MapMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class MapMXBeanImpl
implements MapMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Maps";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile MapStatsDTO stats;

    public MapMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getMapStats(this.cluster, this.name);
    }

    public long getOwnedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getOwnedEntryCount);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getBackupEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getBackupEntryCount);
    }

    public long getOwnedEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getOwnedEntryMemoryCost);
    }

    public long getBackupEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getBackupEntryMemoryCost);
    }

    public long getHeapCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getHeapCost);
    }

    public long getLockedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getLockedEntryCount);
    }

    public long getDirtyEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getDirtyEntryCount);
    }

    public long getHits() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getHits);
    }

    public long getLastAccessTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getLastAccessTime);
    }

    public long getLastUpdateTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getLastUpdateTime);
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getCreationTime);
    }

    public long getPutOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getPutOperationCount);
    }

    public long getGetOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getGetOperationCount);
    }

    public long getRemoveOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getRemoveOperationCount);
    }

    public long getSetOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getSetOperationCount);
    }

    public long getMaxPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getMaxPutLatency);
    }

    public long getMaxGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getMaxGetLatency);
    }

    public long getMaxRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getMaxRemoveLatency);
    }

    public long getMaxSetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getMaxSetLatency);
    }

    public long getTotalPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getTotalPutLatency);
    }

    public long getTotalGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getTotalGetLatency);
    }

    public long getTotalRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getTotalRemoveLatency);
    }

    public long getTotalSetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getTotalSetLatency);
    }

    public long getOtherOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getOtherOperationCount);
    }

    public long getEvents() {
        return MXBeanHelper.safeGet((Object)this.stats, MapStatsDTO::getEvents);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

