/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jet;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.hazelcast.cluster.Member;
import com.hazelcast.webmonitor.config.properties.MetricsConfigurationProperties;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.jet.JetClusterMetricsStore;
import com.hazelcast.webmonitor.service.MemberRemovedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class JetMetricsService
implements AutoCloseable {
    private static final int JET_METRICS_STORE_EXPIRE_AFTER_ACCESS_DURATION = 30;
    private final LoadingCache<String, JetClusterMetricsStore> stores = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build(key -> new JetClusterMetricsStore(properties.getJetRetentionSeconds()));

    public JetMetricsService(MetricsConfigurationProperties properties) {
    }

    public JetClusterMetricsStore getStore(String cluster) {
        return (JetClusterMetricsStore)this.stores.get((Object)cluster);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void save(String cluster, Member member, List<MetricDataPoint> metricDataPoints) {
        ((JetClusterMetricsStore)this.stores.get((Object)cluster)).storeMetricsCollection(member, metricDataPoints);
    }

    @Override
    public void close() {
        this.stores.invalidateAll();
    }

    @EventListener
    public void onMemberLeft(MemberRemovedEvent event) {
        this.getStore(event.getCluster()).removeMember(event.getRemovedMember());
    }
}

