/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

public class StorageSizeFormatter {
    private static final String STORAGE_IN_BYTES = "%,d bytes";
    private final String usedStorage;
    private final String configuredStorage;

    public StorageSizeFormatter(long usedStorageBytes, long configuredStorageBytes) {
        String humanReadableUsedStorage = FileUtils.byteCountToDisplaySize((long)usedStorageBytes);
        String humanReadableConfiguredStorage = FileUtils.byteCountToDisplaySize((long)configuredStorageBytes);
        if (Objects.equals(humanReadableConfiguredStorage, humanReadableUsedStorage)) {
            humanReadableConfiguredStorage = String.format(STORAGE_IN_BYTES, configuredStorageBytes);
            humanReadableUsedStorage = String.format(STORAGE_IN_BYTES, usedStorageBytes);
        }
        this.usedStorage = humanReadableUsedStorage;
        this.configuredStorage = humanReadableConfiguredStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUsedStorage() {
        return this.usedStorage;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getConfiguredStorage() {
        return this.configuredStorage;
    }
}

