/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.MetricsAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class MetricsEqualityAnalyzer
extends MetricsAnalyzer {
    MetricsEqualityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
    }

    List<Problem> identifyProblems(String cluster, Stream<Map.Entry<MemberIdentifier, List<MetricDataPoint>>> metricsStream) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Map metricGroups = metricsStream.collect(Collectors.groupingBy(entry -> {
            List metricDataPoints = (List)entry.getValue();
            return ((MetricDataPoint)metricDataPoints.get(metricDataPoints.size() - 1)).getValue();
        }, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        if (metricGroups.size() > 1) {
            MemberComparisonProblem.MemberComparisonProblemBuilder builder = MemberComparisonProblem.builder().description(String.format("Metric %s differs among the members", this.getMetricName())).advice("").type(Problem.ProblemType.WARNING);
            metricGroups.forEach((metricValue, members) -> builder.addOutlierGroup(OutlierGroup.of((String)String.format("%s is %s", this.getMetricName(), metricValue), (Set)members)));
            problems.add((Problem)builder.build());
        }
        return problems;
    }
}

