/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.MemberMetricsSupplier;
import com.hazelcast.webmonitor.service.healthcheck.MemberProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataPoolAwareAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class MetricsAnalyzer
extends SourceDataPoolAwareAnalyzer {
    private final MemberMetricsSupplier memberMetrics;

    MetricsAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
        this.memberMetrics = pool.subscribeToMetric(this.getMetricName());
    }

    private List<MemberProblem> detectMissingMetrics(Map<MemberIdentifier, List<MetricDataPoint>> metricsMap) {
        return metricsMap.entrySet().stream().filter(entry -> entry.getValue() == null || ((List)entry.getValue()).isEmpty()).map(entry -> new MemberProblem("Cannot get metric " + this.getMetricName(), "", Problem.ProblemType.FAIL, (MemberIdentifier)entry.getKey())).collect(Collectors.toList());
    }

    final AnalysisOutcome doAnalyzeInternal(SourceDataFilter filter, IgnoreList ignoreList) {
        Map metricsMap = filter.filter((Map)this.memberMetrics.get());
        List missingMetricProblems = this.detectMissingMetrics(metricsMap);
        ArrayList problems = new ArrayList(missingMetricProblems);
        Stream<Map.Entry> presentMetricsStream = metricsMap.entrySet().stream().filter(entry -> missingMetricProblems.stream().noneMatch(problem -> problem.member.equals(entry.getKey())));
        problems.addAll(this.identifyProblems(filter.getCluster(), presentMetricsStream));
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), problems);
    }

    abstract List<Problem> identifyProblems(String var1, Stream<Map.Entry<MemberIdentifier, List<MetricDataPoint>>> var2);

    abstract String getMetricName();
}

