/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapBackupCountAnalyzer
extends SemanticConfigAnalyzer {
    MapBackupCountAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        return config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).filter(Predicate.not(MapBackupCountAnalyzer::isBackupCountSet)).map(MapBackupCountAnalyzer::toProblem).collect(Collectors.toUnmodifiableList());
    }

    private static boolean isBackupCountSet(MapConfig mapConfig) {
        return mapConfig.getBackupCount() + mapConfig.getAsyncBackupCount() > 0;
    }

    private static Problem toProblem(MapConfig mapConfig) {
        String mapName = mapConfig.getName();
        return new ClusterWideProblem(String.format("Backup count is set to 0 for map config %s. This may result in data loss in non-graceful shutdown.", mapName), String.format("Set backup count or async backup count for map config %s", mapName), Problem.ProblemType.WARNING, mapName);
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_BACKUP_COUNT_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if backup count is configured properly for maps";
    }
}

