/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ConditionalOnCheckId;
import com.hazelcast.webmonitor.service.healthcheck.DeviceCapacityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.OsMetricsAvailabilityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.ProcessorCountThresholdAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class EnvironmentAnalyzerConfig {
    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.OS_METRICS_AVAILABILITY_ANALYZER)
    Analyzer osMetricsAvailabilityAnalyzer(SourceDataSubscriptionPool pool) {
        return new OsMetricsAvailabilityAnalyzer(pool);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.DEVICE_CAPACITY_ANALYZER)
    Analyzer deviceCapacityAnalyzer(SourceDataSubscriptionPool pool) {
        return new DeviceCapacityAnalyzer(pool);
    }

    @Profile(value={"!hzcloud"})
    @Bean
    @ConditionalOnCheckId(value=AnalyzerCheckId.PROCESSOR_COUNT_THRESHOLD_ANALYZER)
    ProcessorCountThresholdAnalyzer processorCountThresholdAnalyzer(SourceDataSubscriptionPool pool) {
        return new ProcessorCountThresholdAnalyzer(pool);
    }
}

