/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.controller.dto.MemberDetailsDTO;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.healthcheck.AnalysisOutcome;
import com.hazelcast.webmonitor.service.healthcheck.Analyzer;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.IgnoreList;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataFilter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

class ClusterSizeAnalyzer
extends Analyzer {
    static final int THIRTY_MINUTES_IN_MS = 1800000;
    private final AuthenticationManagerImpl authenticationManager;
    private final ClusterManager clusterManager;
    private final MemberManager memberManager;

    AnalysisOutcome doAnalyze(SourceDataFilter filter, IgnoreList ignoreList) {
        String cluster = filter.getCluster();
        Map<Boolean, List<MemberDetailsDTO>> activeAndPassiveMembers = this.memberManager.getMembers(cluster, 0L, 1800000L).stream().filter(Predicate.not(MemberDetailsDTO::isLite)).collect(Collectors.partitioningBy(member -> member.getLastSeenAt() == null));
        boolean clusterSizeChangedRecently = !activeAndPassiveMembers.get(false).isEmpty();
        boolean isRollingUpgradeInProgress = this.clusterManager.isRollingUpgradeInProgress(cluster);
        if (!clusterSizeChangedRecently && !isRollingUpgradeInProgress) {
            List<MemberDetailsDTO> activeMembers = activeAndPassiveMembers.get(true);
            long memberCount = activeMembers.size();
            boolean isDevModeActive = this.authenticationManager.isDevModeActive();
            if (memberCount == 1L) {
                return this.toOutcome("There is only one full member", isDevModeActive ? Problem.ProblemType.INFO : Problem.ProblemType.WARNING);
            }
            if (memberCount == 2L) {
                return this.toOutcome("There are only two full members", isDevModeActive ? Problem.ProblemType.INFO : Problem.ProblemType.WARNING);
            }
            if (memberCount % 2L == 0L && memberCount > 0L) {
                return this.toOutcome("There is an even number of full members", Problem.ProblemType.WARNING);
            }
        }
        return AnalysisOutcome.noProblem((String)this.getCheckId(), (String)this.describeSelf());
    }

    private AnalysisOutcome toOutcome(String caseDescription, Problem.ProblemType type) {
        return AnalysisOutcome.withProblems((String)this.getCheckId(), (String)this.describeSelf(), List.of(new ClusterWideProblem(caseDescription + " in the cluster. This may create problems in the availability and consistency of the data in case of a network partition.", "Consider configuring an odd number of full members for the cluster, ensuring there are at least three full members.", type)));
    }

    String getCheckId() {
        return AnalyzerCheckId.CLUSTER_SIZE_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if the number of full members in the cluster is safe";
    }

    @ConstructorProperties(value={"authenticationManager", "clusterManager", "memberManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterSizeAnalyzer(AuthenticationManagerImpl authenticationManager, ClusterManager clusterManager, MemberManager memberManager) {
        this.authenticationManager = authenticationManager;
        this.clusterManager = clusterManager;
        this.memberManager = memberManager;
    }
}

