/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ConditionalOnCheckId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class AnalyzerExclusionCondition
extends SpringBootCondition {
    AnalyzerExclusionCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        List excludes = (List)Binder.get((Environment)context.getEnvironment()).bind("hazelcast.mc.cluster-health-check.exclude", Bindable.listOf(String.class)).orElse(Collections.emptyList());
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnCheckId.class.getName());
        if (attributes == null) {
            throw new IllegalStateException("%s should only be used with %s annotation".formatted(this.getClass().getSimpleName(), ConditionalOnCheckId.class.getSimpleName()));
        }
        String checkId = ((AnalyzerCheckId)attributes.get("value")).getCheckId();
        if (excludes.contains(checkId)) {
            return ConditionOutcome.noMatch((String)("Analyzer is excluded by check id: " + checkId));
        }
        return ConditionOutcome.match();
    }
}

